/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.config.job;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDistCacheConfigurer {
    private final Conf conf;
    private static final String HDFS_TMP_LIB_DIR = "janusgraphlib";
    private static final Logger log = LoggerFactory.getLogger(AbstractDistCacheConfigurer.class);

    public AbstractDistCacheConfigurer(String mapReduceJarFilename) {
        this.conf = AbstractDistCacheConfigurer.configureByClasspath(mapReduceJarFilename);
    }

    public String getMapredJar() {
        return this.conf.mapReduceJar;
    }

    public ImmutableList<Path> getLocalPaths() {
        return this.conf.paths;
    }

    protected Path uploadFileIfNecessary(FileSystem localFS, Path localPath, FileSystem destFS) throws IOException {
        if (destFS.equals(localFS)) {
            log.debug("Skipping file upload for {} (destination filesystem {} equals local filesystem)", (Object)localPath, (Object)destFS);
            return localPath;
        }
        Path destPath = new Path(destFS.getHomeDirectory() + "/" + HDFS_TMP_LIB_DIR + "/" + localPath.getName());
        Stats fileStats = null;
        try {
            fileStats = this.compareModtimes(localFS, localPath, destFS, destPath);
        }
        catch (IOException e) {
            log.warn("Unable to read or stat file: localPath={}, destPath={}, destFS={}", new Object[]{localPath, destPath, destFS});
        }
        if (fileStats != null && !fileStats.isRemoteCopyCurrent()) {
            log.debug("Copying {} to {}", (Object)localPath, (Object)destPath);
            destFS.copyFromLocalFile(localPath, destPath);
            if (null != fileStats.local) {
                long mtime = fileStats.local.getModificationTime();
                log.debug("Setting modtime on {} to {}", (Object)destPath, (Object)mtime);
                destFS.setTimes(destPath, mtime, -1L);
            }
        }
        return destPath;
    }

    private Stats compareModtimes(FileSystem localFS, Path localPath, FileSystem destFS, Path destPath) throws IOException {
        Stats s = new Stats();
        s.local = localFS.getFileStatus(localPath);
        if (destFS.exists(destPath)) {
            s.dest = destFS.getFileStatus(destPath);
            if (null != s.dest && null != s.local) {
                long d;
                long l = s.local.getModificationTime();
                if (l == (d = s.dest.getModificationTime())) {
                    if (log.isDebugEnabled()) {
                        log.debug("File {} with modtime {} is up-to-date", (Object)destPath, (Object)d);
                    }
                } else if (l < d) {
                    log.warn("File {} has newer modtime ({}) than our local copy {} ({})", new Object[]{destPath, d, localPath, l});
                } else {
                    log.debug("Remote file {} exists but is out-of-date: local={} dest={}", new Object[]{destPath, l, d});
                }
            } else {
                log.debug("Unable to stat file(s): [LOCAL: path={} stat={}] [DEST: path={} stat={}]", new Object[]{localPath, s.local, destPath, s.dest});
            }
        } else {
            log.debug("File {} does not exist", (Object)destPath);
        }
        return s;
    }

    private static Conf configureByClasspath(String mapReduceJarFilename) {
        LinkedList<Path> paths = new LinkedList<Path>();
        String classpath = System.getProperty("java.class.path");
        String mrj = mapReduceJarFilename.toLowerCase();
        String mapReduceJarPath = null;
        for (String classPathEntry : classpath.split(File.pathSeparator)) {
            if (!classPathEntry.toLowerCase().endsWith(".jar") && !classPathEntry.toLowerCase().endsWith(".properties")) continue;
            paths.add(new Path(classPathEntry));
            if (!classPathEntry.toLowerCase().endsWith(mrj)) continue;
            mapReduceJarPath = classPathEntry;
        }
        return new Conf(paths, mapReduceJarPath);
    }

    private static class Stats {
        private FileStatus local;
        private FileStatus dest;

        private Stats() {
        }

        private boolean isRemoteCopyCurrent() {
            return null != this.local && null != this.dest && this.dest.getModificationTime() == this.local.getModificationTime();
        }
    }

    private static class Conf {
        private final ImmutableList<Path> paths;
        private final String mapReduceJar;

        public Conf(List<Path> paths, String mapReduceJar) {
            this.paths = ImmutableList.copyOf(paths);
            this.mapReduceJar = mapReduceJar;
        }
    }
}

