/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.function.slice;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import io.vavr.Tuple;
import io.vavr.Tuple3;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.cql.CQLColValGetter;
import org.janusgraph.diskstorage.cql.CQLTransaction;
import org.janusgraph.diskstorage.cql.function.slice.CQLSliceFunction;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.ChunkedJobDefinition;
import org.janusgraph.diskstorage.util.EntryListComputationContext;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.janusgraph.diskstorage.util.StaticArrayEntryList;
import org.janusgraph.diskstorage.util.backpressure.QueryBackPressure;

public class AsyncCQLSliceFunction
implements CQLSliceFunction {
    private static final Function<Row, Tuple3<StaticBuffer, StaticBuffer, Row>> ROW_TUPLE_3_FUNCTION = row -> row == null ? null : Tuple.of((Object)StaticArrayBuffer.of((ByteBuffer)row.getByteBuffer("column1")), (Object)StaticArrayBuffer.of((ByteBuffer)row.getByteBuffer("value")), (Object)row);
    private final CqlSession session;
    private final PreparedStatement getSlice;
    private final CQLColValGetter getter;
    private final ExecutorService executorService;
    private final QueryBackPressure queryBackPressure;

    public AsyncCQLSliceFunction(CqlSession session, PreparedStatement getSlice, CQLColValGetter getter, ExecutorService executorService, QueryBackPressure queryBackPressure) {
        this.session = session;
        this.getSlice = getSlice;
        this.getter = getter;
        this.executorService = executorService;
        this.queryBackPressure = queryBackPressure;
    }

    @Override
    public CompletableFuture<EntryList> getSlice(KeySliceQuery query, StoreTransaction txh) {
        ChunkedJobDefinition chunkedJobDefinition = new ChunkedJobDefinition();
        this.queryBackPressure.acquireBeforeQuery();
        try {
            this.session.executeAsync((Statement)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)this.getSlice.boundStatementBuilder(new Object[0]).setByteBuffer("key", query.getKey().asByteBuffer())).setByteBuffer("sliceStart", query.getSliceStart().asByteBuffer())).setByteBuffer("sliceEnd", query.getSliceEnd().asByteBuffer())).setInt("maxRows", query.getLimit())).setConsistencyLevel(CQLTransaction.getTransaction(txh).getReadConsistencyLevel())).build()).whenComplete((asyncResultSet, throwable) -> this.acceptDataChunk((AsyncResultSet)asyncResultSet, (Throwable)throwable, (ChunkedJobDefinition<Iterator<Tuple3<StaticBuffer, StaticBuffer, Row>>, EntryListComputationContext, EntryList>)chunkedJobDefinition));
        }
        catch (RuntimeException e) {
            this.queryBackPressure.releaseAfterQuery();
            throw e;
        }
        return chunkedJobDefinition.getResult();
    }

    private void acceptDataChunk(AsyncResultSet resultSet, Throwable exception, ChunkedJobDefinition<Iterator<Tuple3<StaticBuffer, StaticBuffer, Row>>, EntryListComputationContext, EntryList> chunkedJobDefinition) {
        if (exception != null) {
            this.queryBackPressure.releaseAfterQuery();
            chunkedJobDefinition.getResult().completeExceptionally(exception);
            return;
        }
        if (chunkedJobDefinition.getResult().isCompletedExceptionally()) {
            this.queryBackPressure.releaseAfterQuery();
            return;
        }
        try {
            chunkedJobDefinition.getDataChunks().add(Iterators.transform(resultSet.currentPage().iterator(), ROW_TUPLE_3_FUNCTION));
            if (resultSet.hasMorePages()) {
                resultSet.fetchNextPage().whenComplete((asyncResultSet, throwable) -> this.acceptDataChunk((AsyncResultSet)asyncResultSet, (Throwable)throwable, chunkedJobDefinition));
            } else {
                chunkedJobDefinition.setLastChunkRetrieved();
                this.queryBackPressure.releaseAfterQuery();
            }
        }
        catch (RuntimeException e) {
            this.queryBackPressure.releaseAfterQuery();
            chunkedJobDefinition.getResult().completeExceptionally(e);
            throw e;
        }
        StaticArrayEntryList.supplyEntryList(chunkedJobDefinition, (StaticArrayEntry.GetColVal)this.getter, (ExecutorService)this.executorService);
    }
}

