/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.vertex;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphMultiVertexQuery;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.VertexList;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.internal.RelationCategory;
import org.janusgraph.graphdb.query.BackendQueryHolder;
import org.janusgraph.graphdb.query.vertex.BaseVertexCentricQuery;
import org.janusgraph.graphdb.query.vertex.BasicVertexCentricQueryBuilder;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;

public class MultiVertexCentricQueryBuilder
extends BasicVertexCentricQueryBuilder<MultiVertexCentricQueryBuilder>
implements JanusGraphMultiVertexQuery<MultiVertexCentricQueryBuilder> {
    private final Set<InternalVertex> vertices;

    public MultiVertexCentricQueryBuilder(StandardJanusGraphTx tx) {
        this(tx, null);
    }

    public MultiVertexCentricQueryBuilder(StandardJanusGraphTx tx, Integer initialVerticesCapacity) {
        super(tx);
        this.vertices = initialVerticesCapacity != null ? new HashSet(initialVerticesCapacity) : new HashSet();
    }

    @Override
    protected MultiVertexCentricQueryBuilder getThis() {
        return this;
    }

    @Override
    public JanusGraphMultiVertexQuery addVertex(Vertex vertex) {
        assert (vertex != null);
        assert (vertex instanceof InternalVertex);
        this.vertices.add(((InternalVertex)vertex).it());
        return this;
    }

    @Override
    public JanusGraphMultiVertexQuery addAllVertices(Collection<? extends Vertex> vertices) {
        for (Vertex vertex : vertices) {
            this.addVertex(vertex);
        }
        return this;
    }

    protected <Q> Map<JanusGraphVertex, Q> execute(RelationCategory returnType, BasicVertexCentricQueryBuilder.ResultConstructor<Q> resultConstructor) {
        Preconditions.checkArgument((!this.vertices.isEmpty() ? 1 : 0) != 0, (Object)"Need to add at least one vertex to query");
        HashMap<JanusGraphVertex, Q> result = new HashMap<JanusGraphVertex, Q>(this.vertices.size());
        BaseVertexCentricQuery bq = super.constructQuery(returnType);
        this.profiler.setAnnotation("multi", true);
        this.profiler.setAnnotation("vertices", this.vertices.size());
        if (!bq.isEmpty()) {
            Collection<InternalVertex> adjVertices = this.getResolvedAdjVertices();
            this.profiler.setAnnotation("vertices", adjVertices.size());
            if (bq.getQueries().size() == 1) {
                BackendQueryHolder<SliceQuery> backendQueryHolder = bq.getQueries().get(0);
                this.tx.executeMultiQuery(adjVertices, backendQueryHolder.getBackendQuery(), backendQueryHolder.getProfiler());
            } else {
                this.tx.executeMultiSliceMultiQuery(adjVertices, bq.getQueries(), this.profiler);
            }
            for (InternalVertex v : this.vertices) {
                result.put(v, resultConstructor.getResult(v, bq));
            }
        } else {
            for (JanusGraphVertex janusGraphVertex : this.vertices) {
                result.put(janusGraphVertex, resultConstructor.emptyResult());
            }
        }
        return result;
    }

    private Collection<InternalVertex> getResolvedAdjVertices() {
        if (this.hasQueryOnlyGivenVertex()) {
            return this.vertices;
        }
        boolean hasPartitionedVertices = false;
        for (InternalVertex v : this.vertices) {
            if (!this.tx.isPartitionedVertex(v)) continue;
            hasPartitionedVertices = true;
            break;
        }
        if (!hasPartitionedVertices) {
            return this.vertices;
        }
        this.profiler.setAnnotation("partitioned", true);
        HashSet<InternalVertex> adjVertices = new HashSet<InternalVertex>(this.vertices.size() * 2);
        for (InternalVertex v : this.vertices) {
            if (this.tx.isPartitionedVertex(v)) {
                adjVertices.addAll(this.allRequiredRepresentatives(v));
                continue;
            }
            adjVertices.add(v);
        }
        return adjVertices;
    }

    public Map<JanusGraphVertex, Iterable<? extends JanusGraphRelation>> executeImplicitKeyQuery() {
        return new HashMap<JanusGraphVertex, Iterable<? extends JanusGraphRelation>>(this.vertices.size()){
            {
                for (InternalVertex v : MultiVertexCentricQueryBuilder.this.vertices) {
                    this.put(v, MultiVertexCentricQueryBuilder.this.executeImplicitKeyQuery(v));
                }
            }
        };
    }

    @Override
    public Map<JanusGraphVertex, Iterable<JanusGraphEdge>> edges() {
        return this.execute(RelationCategory.EDGE, new BasicVertexCentricQueryBuilder.RelationConstructor(this));
    }

    @Override
    public Map<JanusGraphVertex, Iterable<JanusGraphVertexProperty>> properties() {
        return this.isImplicitKeyQuery(RelationCategory.PROPERTY) ? this.executeImplicitKeyQuery() : this.execute(RelationCategory.PROPERTY, new BasicVertexCentricQueryBuilder.RelationConstructor(this));
    }

    @Override
    public void preFetch() {
        this.profiler.setAnnotation("multiPreFetch", true);
        this.properties();
    }

    @Override
    public Map<JanusGraphVertex, Iterable<JanusGraphRelation>> relations() {
        return this.isImplicitKeyQuery(RelationCategory.RELATION) ? this.executeImplicitKeyQuery() : this.execute(RelationCategory.RELATION, new BasicVertexCentricQueryBuilder.RelationConstructor(this));
    }

    @Override
    public Map<JanusGraphVertex, Iterable<JanusGraphVertex>> vertices() {
        return this.execute(RelationCategory.EDGE, new BasicVertexCentricQueryBuilder.VertexConstructor(this));
    }

    @Override
    public Map<JanusGraphVertex, VertexList> vertexIds() {
        return this.execute(RelationCategory.EDGE, new BasicVertexCentricQueryBuilder.VertexIdConstructor(this));
    }
}

