/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.util;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.ReadBuffer;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.util.ArrayUtil;
import org.janusgraph.diskstorage.util.BaseStaticArrayEntry;
import org.janusgraph.diskstorage.util.ChunkedJobDefinition;
import org.janusgraph.diskstorage.util.EntryListComputationContext;
import org.janusgraph.diskstorage.util.ReadArrayBuffer;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.janusgraph.graphdb.relations.RelationCache;
import org.janusgraph.util.encoding.StringEncoding;

public class StaticArrayEntryList
extends AbstractList<Entry>
implements EntryList {
    private final byte[] data;
    private final long[] limitAndValuePos;
    private final RelationCache[] caches;
    private final EntryMetaData[] metaDataSchema;

    private StaticArrayEntryList(byte[] data, long[] limitAndValuePos, EntryMetaData[] metaDataSchema) {
        Preconditions.checkArgument((data != null && data.length > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((limitAndValuePos != null && limitAndValuePos.length > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((metaDataSchema != null ? 1 : 0) != 0);
        this.data = data;
        this.limitAndValuePos = limitAndValuePos;
        this.caches = new RelationCache[limitAndValuePos.length];
        this.metaDataSchema = metaDataSchema.length == 0 ? StaticArrayEntry.EMPTY_SCHEMA : metaDataSchema;
    }

    private static int getLimit(long limitAndValuePos) {
        return (int)(limitAndValuePos >>> 32);
    }

    private static int getValuePos(long limitAndValuePos) {
        return (int)(limitAndValuePos & Integer.MAX_VALUE);
    }

    private static long getOffsetAndValue(long offset, long valuePos) {
        assert (valuePos > 0L);
        return (offset << 32) + valuePos;
    }

    private boolean hasMetaData() {
        return this.metaDataSchema.length > 0;
    }

    @Override
    public Entry get(int index) {
        Preconditions.checkPositionIndex((int)index, (int)this.limitAndValuePos.length);
        int offset = index > 0 ? StaticArrayEntryList.getLimit(this.limitAndValuePos[index - 1]) : 0;
        EntryMetaData.Map metadata = EntryMetaData.EMPTY_METADATA;
        if (this.hasMetaData()) {
            metadata = new EntryMetaData.Map();
            offset = this.parseMetaData(metadata, offset);
        }
        return new StaticEntry(index, offset, StaticArrayEntryList.getLimit(this.limitAndValuePos[index]), StaticArrayEntryList.getValuePos(this.limitAndValuePos[index]), metadata);
    }

    @Override
    public int size() {
        return this.limitAndValuePos.length;
    }

    @Override
    public int getByteSize() {
        return 40 + this.data.length + 16 + this.limitAndValuePos.length * 8 + 16 + this.caches.length * 40 + 16;
    }

    @Override
    public Iterator<Entry> reuseIterator() {
        return new SwappingEntry();
    }

    public static EntryList of(Entry ... entries) {
        return StaticArrayEntryList.of(Arrays.asList(entries));
    }

    public static EntryList of(Iterable<Entry> entries) {
        Preconditions.checkNotNull(entries);
        int num = 0;
        int dataLength = 0;
        EntryMetaData[] metadataSchema = null;
        for (Entry entry : entries) {
            ++num;
            dataLength += entry.length();
            if (metadataSchema == null) {
                metadataSchema = StaticArrayEntry.ENTRY_GETTER.getMetaSchema(entry);
            }
            dataLength += StaticArrayEntryList.getMetaDataSize(metadataSchema, entry, StaticArrayEntry.ENTRY_GETTER);
        }
        if (num == 0) {
            return EMPTY_LIST;
        }
        byte[] data = new byte[dataLength];
        long[] limitAndValuePos = new long[num];
        int pos = 0;
        CopyFactory cpf = new CopyFactory(data);
        for (Entry entry : entries) {
            cpf.addMetaData(metadataSchema, entry);
            entry.as(cpf);
            limitAndValuePos[pos] = StaticArrayEntryList.getOffsetAndValue(cpf.dataOffset, entry.getValuePosition());
            ++pos;
        }
        assert (cpf.dataOffset == data.length);
        assert (pos == limitAndValuePos.length);
        return new StaticArrayEntryList(data, limitAndValuePos, metadataSchema);
    }

    public static <E> EntryList ofBytes(Iterable<E> elements, StaticArrayEntry.GetColVal<E, byte[]> getter) {
        return StaticArrayEntryList.of(elements, getter, StaticArrayEntry.ByteArrayHandler.INSTANCE);
    }

    public static <E> EntryList ofByteBuffer(Iterable<E> elements, StaticArrayEntry.GetColVal<E, ByteBuffer> getter) {
        return StaticArrayEntryList.of(elements, getter, StaticArrayEntry.ByteBufferHandler.INSTANCE);
    }

    public static <E> EntryList ofStaticBuffer(Iterable<E> elements, StaticArrayEntry.GetColVal<E, StaticBuffer> getter) {
        return StaticArrayEntryList.of(elements, getter, StaticArrayEntry.StaticBufferHandler.INSTANCE);
    }

    public static <E> EntryList ofByteBuffer(Iterator<E> elements, StaticArrayEntry.GetColVal<E, ByteBuffer> getter) {
        return StaticArrayEntryList.of(elements, getter, StaticArrayEntry.ByteBufferHandler.INSTANCE);
    }

    public static <E> EntryList ofStaticBuffer(Iterator<E> elements, StaticArrayEntry.GetColVal<E, StaticBuffer> getter) {
        return StaticArrayEntryList.of(elements, getter, StaticArrayEntry.StaticBufferHandler.INSTANCE);
    }

    private static <E, D> EntryList of(Iterable<E> elements, StaticArrayEntry.GetColVal<E, D> getter, StaticArrayEntry.DataHandler<D> dataHandler) {
        Preconditions.checkArgument((elements != null && getter != null && dataHandler != null ? 1 : 0) != 0);
        int num = 0;
        int dataLength = 0;
        EntryMetaData[] metadataSchema = null;
        for (E element : elements) {
            ++num;
            dataLength += dataHandler.getSize(getter.getColumn(element));
            dataLength += dataHandler.getSize(getter.getValue(element));
            if (metadataSchema == null) {
                metadataSchema = getter.getMetaSchema(element);
            }
            dataLength += StaticArrayEntryList.getMetaDataSize(metadataSchema, element, getter);
        }
        if (num == 0) {
            return EMPTY_LIST;
        }
        byte[] data = new byte[dataLength];
        long[] limitAndValuePos = new long[num];
        int pos = 0;
        int offset = 0;
        for (E element : elements) {
            if (element == null) {
                throw new IllegalArgumentException("Unexpected null element in result set");
            }
            offset = StaticArrayEntryList.writeMetaData(data, offset, metadataSchema, element, getter);
            D col = getter.getColumn(element);
            dataHandler.copy(col, data, offset);
            int valuePos = dataHandler.getSize(col);
            D val = getter.getValue(element);
            dataHandler.copy(val, data, offset += valuePos);
            limitAndValuePos[pos] = StaticArrayEntryList.getOffsetAndValue(offset += dataHandler.getSize(val), valuePos);
            ++pos;
        }
        assert (offset == data.length);
        assert (pos == limitAndValuePos.length);
        return new StaticArrayEntryList(data, limitAndValuePos, metadataSchema);
    }

    private static <E, D> EntryList of(Iterator<E> elements, StaticArrayEntry.GetColVal<E, D> getter, StaticArrayEntry.DataHandler<D> dataHandler) {
        Preconditions.checkArgument((elements != null && getter != null && dataHandler != null ? 1 : 0) != 0);
        if (!elements.hasNext()) {
            return EMPTY_LIST;
        }
        EntryListComputationContext context = StaticArrayEntryList.generateComputationContext();
        StaticArrayEntryList.applyElementsComputation(elements, getter, dataHandler, context);
        return StaticArrayEntryList.convert(context);
    }

    public static EntryListComputationContext generateComputationContext() {
        long[] limitAndValuePos = new long[10];
        return new EntryListComputationContext(limitAndValuePos, new byte[limitAndValuePos.length * 15], null, 0, 0);
    }

    public static <E> void supplyEntryList(ChunkedJobDefinition<Iterator<E>, EntryListComputationContext, EntryList> chunkedJobDefinition, StaticArrayEntry.GetColVal<E, StaticBuffer> getter, ExecutorService executorService) {
        StaticArrayEntryList.supplyEntryList(chunkedJobDefinition, getter, StaticArrayEntry.StaticBufferHandler.INSTANCE, executorService);
    }

    private static <E, D> void supplyEntryList(ChunkedJobDefinition<Iterator<E>, EntryListComputationContext, EntryList> chunkedJobDefinition, StaticArrayEntry.GetColVal<E, D> getter, StaticArrayEntry.DataHandler<D> dataHandler, ExecutorService executorService) {
        assert (chunkedJobDefinition != null && getter != null && dataHandler != null);
        executorService.execute(() -> {
            Queue chunksQueue = chunkedJobDefinition.getDataChunks();
            if (!chunkedJobDefinition.tryLockProcessing()) {
                return;
            }
            try {
                if (chunkedJobDefinition.getResult().isDone()) {
                    return;
                }
                Iterator elements = chunksQueue.isEmpty() ? Collections.emptyIterator() : (Iterator)chunksQueue.remove();
                EntryListComputationContext context = (EntryListComputationContext)chunkedJobDefinition.getProcessedDataContext();
                if (context == null) {
                    if (chunkedJobDefinition.isLastChunkRetrieved() && chunksQueue.isEmpty() && !elements.hasNext()) {
                        chunkedJobDefinition.complete(EMPTY_LIST);
                        return;
                    }
                    context = StaticArrayEntryList.generateComputationContext();
                    chunkedJobDefinition.setProcessedDataContext(context);
                }
                while (true) {
                    if (elements.hasNext()) {
                        StaticArrayEntryList.applyElementsComputation(elements, getter, dataHandler, context);
                    }
                    if (chunksQueue.isEmpty()) break;
                    elements = (Iterator)chunksQueue.remove();
                }
                if (chunkedJobDefinition.isLastChunkRetrieved() && chunksQueue.isEmpty()) {
                    chunkedJobDefinition.complete((EntryList)((Object)(context.metadataSchema == null ? EMPTY_LIST : StaticArrayEntryList.convert(context))));
                }
            }
            catch (Throwable throwable) {
                chunkedJobDefinition.getResult().completeExceptionally(throwable);
                return;
            }
            finally {
                chunkedJobDefinition.unlockProcessing();
            }
            if (!chunksQueue.isEmpty() || chunkedJobDefinition.isLastChunkRetrieved() && !chunkedJobDefinition.getResult().isDone()) {
                StaticArrayEntryList.supplyEntryList(chunkedJobDefinition, getter, dataHandler, executorService);
            }
        });
    }

    private static <E, D> void applyElementsComputation(Iterator<E> elements, StaticArrayEntry.GetColVal<E, D> getter, StaticArrayEntry.DataHandler<D> dataHandler, EntryListComputationContext context) {
        long[] limitAndValuePos = context.limitAndValuePos;
        byte[] data = context.data;
        EntryMetaData[] metadataSchema = context.metadataSchema;
        int pos = context.pos;
        int offset = context.offset;
        while (elements.hasNext()) {
            E element = elements.next();
            if (element == null) {
                throw new IllegalArgumentException("Unexpected null element in result set");
            }
            if (metadataSchema == null) {
                metadataSchema = getter.getMetaSchema(element);
            }
            D col = getter.getColumn(element);
            D val = getter.getValue(element);
            int colSize = dataHandler.getSize(col);
            assert (colSize > 0);
            int valueSize = dataHandler.getSize(val);
            int metaDataSize = StaticArrayEntryList.getMetaDataSize(metadataSchema, element, getter);
            data = StaticArrayEntryList.ensureSpace(data, offset, colSize + valueSize + metaDataSize);
            offset = StaticArrayEntryList.writeMetaData(data, offset, metadataSchema, element, getter);
            dataHandler.copy(col, data, offset);
            dataHandler.copy(val, data, offset += colSize);
            limitAndValuePos = StaticArrayEntryList.ensureSpace(limitAndValuePos, pos);
            limitAndValuePos[pos] = StaticArrayEntryList.getOffsetAndValue(offset += valueSize, colSize);
            ++pos;
        }
        assert (offset <= data.length);
        context.limitAndValuePos = limitAndValuePos;
        context.data = data;
        context.metadataSchema = metadataSchema;
        context.pos = pos;
        context.offset = offset;
    }

    private static StaticArrayEntryList convert(EntryListComputationContext context) {
        if (context.data.length > context.offset + (context.offset >> 1)) {
            byte[] newData = new byte[context.offset];
            System.arraycopy(context.data, 0, newData, 0, context.offset);
            context.data = newData;
        }
        if (context.pos < context.limitAndValuePos.length) {
            long[] newPos = new long[context.pos];
            System.arraycopy(context.limitAndValuePos, 0, newPos, 0, context.pos);
            context.limitAndValuePos = newPos;
        }
        assert (context.offset <= context.data.length);
        assert (context.pos == context.limitAndValuePos.length);
        return new StaticArrayEntryList(context.data, context.limitAndValuePos, context.metadataSchema);
    }

    private static byte[] ensureSpace(byte[] data, int offset, int length) {
        int minCapacity = offset + length;
        if (minCapacity > 0 && minCapacity <= data.length) {
            return data;
        }
        byte[] newData = new byte[ArrayUtil.growSpace(data.length, minCapacity)];
        System.arraycopy(data, 0, newData, 0, offset);
        return newData;
    }

    private static long[] ensureSpace(long[] data, int offset) {
        if (offset + 1 <= data.length) {
            return data;
        }
        long[] newData = new long[ArrayUtil.growSpace(data.length, offset + 1)];
        System.arraycopy(data, 0, newData, 0, offset);
        return newData;
    }

    private int parseMetaData(Map<EntryMetaData, Object> metadata, int baseOffset) {
        assert (this.hasMetaData());
        for (EntryMetaData meta : this.metaDataSchema) {
            MetaDataSerializer s = StaticArrayEntryList.getSerializer(meta);
            Object d = s.read(this.data, baseOffset);
            baseOffset += s.getByteLength(d);
            metadata.put(meta, d);
        }
        return baseOffset;
    }

    private static <D, K> int getMetaDataSize(EntryMetaData[] schema, D entry, StaticArrayEntry.GetColVal<D, K> metaGetter) {
        int dataSize = 0;
        if (schema.length > 0) {
            assert (schema.length == metaGetter.getMetaSchema(entry).length);
            for (EntryMetaData meta : schema) {
                Object data = metaGetter.getMetaData(entry, meta);
                assert (data != null);
                dataSize += StaticArrayEntryList.getSerializer(meta).getByteLength(data);
            }
        }
        return dataSize;
    }

    private static <D, K> int writeMetaData(byte[] data, int startPos, EntryMetaData[] schema, D entry, StaticArrayEntry.GetColVal<D, K> metaGetter) {
        if (schema.length == 0) {
            return startPos;
        }
        for (EntryMetaData meta : schema) {
            Object d = metaGetter.getMetaData(entry, meta);
            assert (d != null);
            MetaDataSerializer s = StaticArrayEntryList.getSerializer(meta);
            s.write(data, startPos, d);
            startPos += s.getByteLength(d);
        }
        return startPos;
    }

    public static MetaDataSerializer getSerializer(EntryMetaData meta) {
        switch (meta) {
            case TTL: {
                return IntSerializer.INSTANCE;
            }
            case TIMESTAMP: {
                return LongSerializer.INSTANCE;
            }
            case VISIBILITY: {
                return ASCIIStringSerializer.INSTANCE;
            }
        }
        throw new AssertionError((Object)("Unexpected meta data: " + (Object)((Object)meta)));
    }

    private static final class ASCIIStringSerializer
    extends Enum<ASCIIStringSerializer>
    implements MetaDataSerializer<String> {
        public static final /* enum */ ASCIIStringSerializer INSTANCE = new ASCIIStringSerializer();
        private static final /* synthetic */ ASCIIStringSerializer[] $VALUES;

        public static ASCIIStringSerializer[] values() {
            return (ASCIIStringSerializer[])$VALUES.clone();
        }

        public static ASCIIStringSerializer valueOf(String name) {
            return Enum.valueOf(ASCIIStringSerializer.class, name);
        }

        @Override
        public int getByteLength(String value) {
            return StringEncoding.getAsciiByteLength(value);
        }

        @Override
        public void write(byte[] data, int startPos, String value) {
            assert (data.length >= startPos + this.getByteLength(value));
            StringEncoding.writeAsciiString(data, startPos, value);
        }

        @Override
        public String read(byte[] data, int startPos) {
            return StringEncoding.readAsciiString(data, startPos);
        }

        static {
            $VALUES = new ASCIIStringSerializer[]{INSTANCE};
        }
    }

    private static final class LongSerializer
    extends Enum<LongSerializer>
    implements MetaDataSerializer<Long> {
        public static final /* enum */ LongSerializer INSTANCE = new LongSerializer();
        private static final /* synthetic */ LongSerializer[] $VALUES;

        public static LongSerializer[] values() {
            return (LongSerializer[])$VALUES.clone();
        }

        public static LongSerializer valueOf(String name) {
            return Enum.valueOf(LongSerializer.class, name);
        }

        @Override
        public int getByteLength(Long value) {
            return 8;
        }

        @Override
        public void write(byte[] data, int startPos, Long value) {
            assert (data.length >= startPos + this.getByteLength(value));
            assert (value != null);
            StaticArrayBuffer.putLong(data, startPos, value);
        }

        @Override
        public Long read(byte[] data, int startPos) {
            assert (data.length >= startPos + 8);
            return StaticArrayBuffer.getLong(data, startPos);
        }

        static {
            $VALUES = new LongSerializer[]{INSTANCE};
        }
    }

    private static final class IntSerializer
    extends Enum<IntSerializer>
    implements MetaDataSerializer<Integer> {
        public static final /* enum */ IntSerializer INSTANCE = new IntSerializer();
        private static final /* synthetic */ IntSerializer[] $VALUES;

        public static IntSerializer[] values() {
            return (IntSerializer[])$VALUES.clone();
        }

        public static IntSerializer valueOf(String name) {
            return Enum.valueOf(IntSerializer.class, name);
        }

        @Override
        public int getByteLength(Integer value) {
            return 4;
        }

        @Override
        public void write(byte[] data, int startPos, Integer value) {
            assert (data.length >= startPos + this.getByteLength(value));
            assert (value != null);
            StaticArrayBuffer.putInt(data, startPos, value);
        }

        @Override
        public Integer read(byte[] data, int startPos) {
            assert (data.length >= startPos + 4);
            return StaticArrayBuffer.getInt(data, startPos);
        }

        static {
            $VALUES = new IntSerializer[]{INSTANCE};
        }
    }

    public static interface MetaDataSerializer<V> {
        public int getByteLength(V var1);

        public void write(byte[] var1, int var2, V var3);

        public V read(byte[] var1, int var2);
    }

    private static class CopyFactory
    implements StaticBuffer.Factory<Boolean> {
        private final byte[] data;
        private int dataOffset = 0;

        private CopyFactory(byte[] data) {
            this.data = data;
        }

        public void addMetaData(EntryMetaData[] schema, Entry entry) {
            this.dataOffset = StaticArrayEntryList.writeMetaData(this.data, this.dataOffset, schema, entry, StaticArrayEntry.ENTRY_GETTER);
        }

        @Override
        public Boolean get(byte[] array, int offset, int limit) {
            int len = limit - offset;
            assert (len >= 0);
            System.arraycopy(array, offset, this.data, this.dataOffset, len);
            this.dataOffset += len;
            return Boolean.TRUE;
        }
    }

    private class SwappingEntry
    extends ReadArrayBuffer
    implements Entry,
    Iterator<Entry> {
        private int currentIndex;
        private int currentValuePos;
        private Map<EntryMetaData, Object> metadata;

        public SwappingEntry() {
            super(StaticArrayEntryList.this.data, 0);
            this.currentIndex = -1;
            this.currentValuePos = -1;
            this.metadata = null;
        }

        private void verifyAccess() {
            Preconditions.checkArgument((this.currentIndex >= 0 ? 1 : 0) != 0, (Object)"Illegal iterator access");
        }

        @Override
        public int getValuePosition() {
            this.verifyAccess();
            return this.currentValuePos;
        }

        @Override
        public ReadBuffer asReadBuffer() {
            super.movePositionTo(0);
            return this;
        }

        @Override
        public RelationCache getCache() {
            this.verifyAccess();
            return StaticArrayEntryList.this.caches[this.currentIndex];
        }

        @Override
        public void setCache(RelationCache cache) {
            this.verifyAccess();
            ((StaticArrayEntryList)StaticArrayEntryList.this).caches[this.currentIndex] = cache;
        }

        @Override
        public boolean hasMetaData() {
            this.verifyAccess();
            return !this.metadata.isEmpty();
        }

        @Override
        public Map<EntryMetaData, Object> getMetaData() {
            this.verifyAccess();
            return this.metadata;
        }

        @Override
        public boolean hasValue() {
            return this.currentValuePos < this.length();
        }

        @Override
        public StaticBuffer getColumn() {
            return this.getColumnAs(StaticBuffer.STATIC_FACTORY);
        }

        @Override
        public <T> T getColumnAs(StaticBuffer.Factory<T> factory) {
            return super.as(factory, 0, this.currentValuePos);
        }

        @Override
        public StaticBuffer getValue() {
            return this.getValueAs(StaticBuffer.STATIC_FACTORY);
        }

        @Override
        public <T> T getValueAs(StaticBuffer.Factory<T> factory) {
            return super.as(factory, this.currentValuePos, super.length() - this.currentValuePos);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof StaticBuffer)) {
                return false;
            }
            Entry b = (Entry)o;
            return this.getValuePosition() == b.getValuePosition() && this.compareTo(this.getValuePosition(), b, this.getValuePosition()) == 0;
        }

        @Override
        public int hashCode() {
            return this.hashCode(this.getValuePosition());
        }

        @Override
        public int compareTo(StaticBuffer other) {
            int otherLen = other instanceof Entry ? ((Entry)other).getValuePosition() : other.length();
            return this.compareTo(this.getValuePosition(), other, otherLen);
        }

        @Override
        public String toString() {
            String s = super.toString();
            int pos = this.getValuePosition() * 4;
            return s.substring(0, pos - 1) + "->" + s.substring(pos);
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex + 1 < StaticArrayEntryList.this.size();
        }

        @Override
        public Entry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.currentIndex;
            int newOffset = this.currentIndex > 0 ? StaticArrayEntryList.getLimit(StaticArrayEntryList.this.limitAndValuePos[this.currentIndex - 1]) : 0;
            this.metadata = EntryMetaData.EMPTY_METADATA;
            if (StaticArrayEntryList.this.hasMetaData()) {
                this.metadata = new EntryMetaData.Map();
                newOffset = StaticArrayEntryList.this.parseMetaData(this.metadata, newOffset);
            }
            super.reset(newOffset, StaticArrayEntryList.getLimit(StaticArrayEntryList.this.limitAndValuePos[this.currentIndex]));
            this.currentValuePos = StaticArrayEntryList.getValuePos(StaticArrayEntryList.this.limitAndValuePos[this.currentIndex]);
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class StaticEntry
    extends BaseStaticArrayEntry {
        private final int index;
        private final Map<EntryMetaData, Object> metadata;

        public StaticEntry(int index, int offset, int limit, int valuePos, Map<EntryMetaData, Object> metadata) {
            super(StaticArrayEntryList.this.data, offset, limit, valuePos);
            this.index = index;
            this.metadata = metadata;
        }

        @Override
        public boolean hasMetaData() {
            return !this.metadata.isEmpty();
        }

        @Override
        public Map<EntryMetaData, Object> getMetaData() {
            return this.metadata;
        }

        @Override
        public RelationCache getCache() {
            return StaticArrayEntryList.this.caches[this.index];
        }

        @Override
        public void setCache(RelationCache cache) {
            Preconditions.checkNotNull((Object)cache);
            ((StaticArrayEntryList)StaticArrayEntryList.this).caches[this.index] = cache;
        }
    }
}

