/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.janusgraph.core.JanusGraphException;

public class CompletableFutureUtil {
    private CompletableFutureUtil() {
    }

    public static Throwable unwrapExecutionException(Throwable e) {
        Throwable rootException = e;
        while (rootException.getCause() != null && (rootException instanceof ExecutionException || rootException instanceof CompletionException)) {
            Throwable cause = rootException.getCause();
            for (Throwable suppressedException : rootException.getSuppressed()) {
                cause.addSuppressed(suppressedException);
            }
            rootException = cause;
        }
        return rootException;
    }

    public static <T> T get(CompletableFuture<T> future) {
        try {
            return future.get();
        }
        catch (Throwable e) {
            Throwable rootException = CompletableFutureUtil.unwrapExecutionException(e);
            if (rootException instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            } else if (rootException.getCause() instanceof InterruptedException) {
                rootException = rootException.getCause();
            }
            throw new JanusGraphException(rootException);
        }
    }

    public static <K, V> Map<K, V> unwrap(Map<K, CompletableFuture<V>> futureMap) throws Throwable {
        HashMap<K, V> resultMap = new HashMap<K, V>(futureMap.size());
        Throwable firstException = null;
        for (Map.Entry<K, CompletableFuture<V>> entry : futureMap.entrySet()) {
            try {
                resultMap.put(entry.getKey(), entry.getValue().get());
            }
            catch (Throwable throwable) {
                if (firstException == null) {
                    firstException = throwable;
                    continue;
                }
                firstException.addSuppressed(throwable);
            }
        }
        if (firstException != null) {
            throw firstException;
        }
        return resultMap;
    }

    public static <K, V, R> Map<K, Map<V, R>> unwrapMapOfMaps(Map<K, Map<V, CompletableFuture<R>>> futureMap) throws Throwable {
        HashMap<K, Map<V, R>> resultMap = new HashMap<K, Map<V, R>>(futureMap.size());
        Throwable firstException = null;
        for (Map.Entry<K, Map<V, CompletableFuture<R>>> entry : futureMap.entrySet()) {
            try {
                resultMap.put(entry.getKey(), CompletableFutureUtil.unwrap(entry.getValue()));
            }
            catch (Throwable throwable) {
                if (firstException == null) {
                    firstException = throwable;
                    continue;
                }
                firstException.addSuppressed(throwable);
            }
        }
        if (firstException != null) {
            throw firstException;
        }
        return resultMap;
    }

    public static <V> void awaitAll(Collection<CompletableFuture<V>> futureCollection) throws Throwable {
        Throwable firstException = null;
        for (CompletableFuture<V> future : futureCollection) {
            try {
                future.get();
            }
            catch (Throwable throwable) {
                if (firstException == null) {
                    firstException = throwable;
                    continue;
                }
                firstException.addSuppressed(throwable);
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }
}

