/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.keycolumnvalue;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.diskstorage.util.EntryArrayList;
import org.janusgraph.graphdb.query.BackendQuery;
import org.janusgraph.graphdb.query.BaseQuery;

public class SliceQuery
extends BaseQuery
implements BackendQuery<SliceQuery> {
    private final StaticBuffer sliceStart;
    private final StaticBuffer sliceEnd;
    private String type;

    public SliceQuery(StaticBuffer sliceStart, StaticBuffer sliceEnd, String type) {
        this(sliceStart, sliceEnd);
        this.type = type;
    }

    public SliceQuery(StaticBuffer sliceStart, StaticBuffer sliceEnd) {
        assert (sliceStart != null && sliceEnd != null);
        this.sliceStart = sliceStart;
        this.sliceEnd = sliceEnd;
    }

    public SliceQuery(SliceQuery query) {
        this(query.getSliceStart(), query.getSliceEnd());
        this.setLimit(query.getLimit());
    }

    public StaticBuffer getSliceStart() {
        return this.sliceStart;
    }

    public StaticBuffer getSliceEnd() {
        return this.sliceEnd;
    }

    public int hashCode() {
        return Objects.hash(this.sliceStart, this.sliceEnd, this.getLimit());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SliceQuery)) {
            return false;
        }
        SliceQuery oth = (SliceQuery)other;
        return this.sliceStart.equals(oth.sliceStart) && this.sliceEnd.equals(oth.sliceEnd) && this.getLimit() == oth.getLimit();
    }

    public boolean subsumes(SliceQuery oth) {
        Preconditions.checkNotNull((Object)oth);
        if (this == oth) {
            return true;
        }
        if (oth.getLimit() > this.getLimit()) {
            return false;
        }
        if (!this.hasLimit()) {
            return this.sliceStart.compareTo(oth.sliceStart) <= 0 && this.sliceEnd.compareTo(oth.sliceEnd) >= 0;
        }
        return this.sliceStart.compareTo(oth.sliceStart) == 0 && this.sliceEnd.compareTo(oth.sliceEnd) >= 0;
    }

    public EntryList getSubset(SliceQuery otherQuery, EntryList otherResult) {
        Entry e;
        assert (otherQuery.subsumes(this));
        int pos = Collections.binarySearch(otherResult, this.sliceStart);
        if (pos < 0) {
            pos = -pos - 1;
        }
        ArrayList<Entry> result = new ArrayList<Entry>();
        while (pos < otherResult.size() && result.size() < this.getLimit() && (e = (Entry)otherResult.get(pos)).getColumnAs(StaticBuffer.STATIC_FACTORY).compareTo(this.sliceEnd) < 0) {
            result.add(e);
            ++pos;
        }
        return EntryArrayList.of(result);
    }

    public boolean contains(StaticBuffer buffer) {
        return this.sliceStart.compareTo(buffer) <= 0 && this.sliceEnd.compareTo(buffer) > 0;
    }

    public static StaticBuffer pointRange(StaticBuffer point) {
        return BufferUtil.nextBiggerBuffer(point);
    }

    @Override
    public SliceQuery setLimit(int limit) {
        Preconditions.checkArgument((!this.hasLimit() ? 1 : 0) != 0);
        super.setLimit(limit);
        return this;
    }

    @Override
    public SliceQuery updateLimit(int newLimit) {
        return new SliceQuery(this.sliceStart, this.sliceEnd).setLimit(newLimit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.type != null) {
            sb.append(this.type).append(":");
        }
        sb.append("SliceQuery[").append(this.getSliceStart()).append(",").append(this.getSliceEnd()).append(")");
        if (this.hasLimit()) {
            sb.append("@").append(this.getLimit());
        }
        return sb.toString();
    }
}

