/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.BackupArchiveLocation;
import com.sleepycat.je.BackupFSArchiveCopy;
import com.sleepycat.je.BackupFileCopy;
import com.sleepycat.je.BackupFileLocation;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.dbi.BackupManager;
import com.sleepycat.je.dbi.SnapshotManifest;
import com.sleepycat.je.utilint.CmdUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;

public class CheckSnapshot {
    private static final String USAGE = "usage: " + CmdUtil.getJavaCommand(CheckSnapshot.class) + "\n       -m <file>    # the manifest of the snapshot to check\n       -c <file>    # the copy class configuration\n       -l <file>    # the location class configuration\n       [-C <class>] # the copy class\n       [-L <class>] # the location class\n       [-V]         # print version";
    private SnapshotManifest manifest;
    private BackupFileCopy backupCopy;
    private BackupArchiveLocation backupLocation;

    public CheckSnapshot(SnapshotManifest manifest, BackupFileCopy backupCopy, BackupArchiveLocation backupLocation) {
        this.manifest = Objects.requireNonNull(manifest);
        this.backupCopy = Objects.requireNonNull(backupCopy);
        this.backupLocation = Objects.requireNonNull(backupLocation);
    }

    private CheckSnapshot() {
    }

    public static void main(String[] argv) {
        try {
            CheckSnapshot.mainInternal(System.out, argv);
        }
        catch (UsageException e) {
            System.err.println(e.getMessage());
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    static void mainInternal(PrintStream out, String ... argv) {
        CheckSnapshot checkSnapshot = new CheckSnapshot();
        checkSnapshot.parseArgs(argv);
        SnapshotManifest manifest = checkSnapshot.manifest;
        out.println("Checking snapshot " + manifest.getSnapshot() + " for node " + manifest.getNodeName());
        out.println("Snapshot is " + (manifest.getIsComplete() ? "complete" : "not complete"));
        out.println(checkSnapshot.check());
        out.println("Check passed");
    }

    private void printUsage(String msg) {
        if (msg == null) {
            throw new UsageException(USAGE);
        }
        throw new RuntimeException(msg + "\n" + USAGE);
    }

    private void parseArgs(String[] argv) {
        int argc = 0;
        int nArgs = argv.length;
        if (nArgs == 0) {
            this.printUsage(null);
        }
        Path manifestPath = null;
        Path copyConfig = null;
        Path locationConfig = null;
        String copyClass = null;
        String locationClass = null;
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-m")) {
                if (argc < nArgs) {
                    manifestPath = Paths.get(argv[argc++], new String[0]);
                    continue;
                }
                this.printUsage("-m requires an argument");
                continue;
            }
            if (thisArg.equals("-c")) {
                if (argc < nArgs) {
                    copyConfig = Paths.get(argv[argc++], new String[0]);
                    continue;
                }
                this.printUsage("-c requires an argument");
                continue;
            }
            if (thisArg.equals("-l")) {
                if (argc < nArgs) {
                    locationConfig = Paths.get(argv[argc++], new String[0]);
                    continue;
                }
                this.printUsage("-l requires an argument");
                continue;
            }
            if (thisArg.equals("-C")) {
                if (argc < nArgs) {
                    copyClass = argv[argc++];
                    continue;
                }
                this.printUsage("-C requires an argument");
                continue;
            }
            if (thisArg.equals("-L")) {
                if (argc < nArgs) {
                    locationClass = argv[argc++];
                    continue;
                }
                this.printUsage("-L requires an argument");
                continue;
            }
            if (thisArg.equals("-V")) {
                throw new UsageException(JEVersion.CURRENT_VERSION.toString());
            }
            this.printUsage("Unknown argument: " + thisArg);
        }
        if (manifestPath == null) {
            this.printUsage("-m is a required argument");
        }
        if (copyConfig == null) {
            this.printUsage("-c is a required argument");
        }
        if (locationConfig == null) {
            this.printUsage("-l is a required argument");
        }
        try {
            this.manifest = CheckSnapshot.readManifest(manifestPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Problem reading manifest file " + manifestPath + ": " + e);
        }
        try {
            this.backupCopy = copyClass != null ? BackupManager.getImplementationInstance(BackupFileCopy.class, copyClass) : new BackupFSArchiveCopy();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Problem with copy class " + copyClass + ": " + e);
        }
        try {
            this.backupCopy.initialize(copyConfig.toFile());
        }
        catch (Exception e) {
            throw new RuntimeException("Problem initializing copy class from " + copyConfig + ": " + e);
        }
        try {
            this.backupLocation = locationClass != null ? BackupManager.getImplementationInstance(BackupArchiveLocation.class, locationClass) : new BackupFileLocation();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Problem with location class " + locationClass + ": " + e);
        }
        try {
            this.backupLocation.initialize(this.manifest.getNodeName(), locationConfig.toFile());
        }
        catch (Exception e) {
            throw new RuntimeException("Problem initializing location class from " + locationConfig + ": " + e);
        }
    }

    public String check() {
        String msg;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baos);
        boolean ok = true;
        if (!this.verifyFiles("snapshot", this.manifest.getSnapshotFiles(), out)) {
            ok = false;
        }
        if (!this.verifyFiles("erased", this.manifest.getErasedFiles(), out)) {
            ok = false;
        }
        try {
            msg = baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected exception: " + e);
        }
        if (!ok) {
            throw new RuntimeException(msg);
        }
        return msg;
    }

    public static SnapshotManifest readManifest(Path manifestPath) throws IOException {
        return SnapshotManifest.deserialize(Files.readAllBytes(manifestPath));
    }

    private boolean verifyFiles(String type, Map<String, SnapshotManifest.LogFileInfo> files, PrintStream out) {
        int copyCount = 0;
        boolean ok = true;
        for (Map.Entry<String, SnapshotManifest.LogFileInfo> entry : files.entrySet()) {
            String archiveChecksum;
            SnapshotManifest.LogFileInfo info = entry.getValue();
            if (!info.getIsCopied()) continue;
            ++copyCount;
            String logFile = info.getSnapshot() + "/" + entry.getKey();
            URL url = this.backupLocation.getArchiveLocation(logFile);
            try {
                archiveChecksum = BackupManager.checksumToHex(this.backupCopy.checksum(url));
            }
            catch (IOException | InterruptedException e) {
                out.println("Error: Problem reading checksum for " + type + " log file " + logFile + ": " + e);
                ok = false;
                continue;
            }
            if (info.getChecksum().equals(archiveChecksum)) continue;
            out.println("Error: Incorrect checksum for " + type + " log file " + logFile + ": expected " + info.getChecksum() + ", found " + archiveChecksum);
            ok = false;
        }
        out.println("Copied " + type + " log files: " + copyCount);
        return ok;
    }

    static class UsageException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;

        UsageException(String msg) {
            super(msg);
        }
    }
}

