/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileInfo;
import org.apache.hadoop.hbase.regionserver.CellSink;
import org.apache.hadoop.hbase.regionserver.CreateStoreFileWriterParams;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.ShipperListener;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CloseChecker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputControlUtil;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class Compactor<T extends CellSink> {
    private static final Logger LOG = LoggerFactory.getLogger(Compactor.class);
    protected static final long COMPACTION_PROGRESS_LOG_INTERVAL = 60000L;
    protected final Configuration conf;
    protected final HStore store;
    protected final int compactionKVMax;
    protected final Compression.Algorithm majorCompactionCompression;
    protected final Compression.Algorithm minorCompactionCompression;
    protected int keepSeqIdPeriod;
    protected static final String MAJOR_COMPACTION_DROP_CACHE = "hbase.regionserver.majorcompaction.pagecache.drop";
    protected static final String MINOR_COMPACTION_DROP_CACHE = "hbase.regionserver.minorcompaction.pagecache.drop";
    protected final boolean dropCacheMajor;
    protected final boolean dropCacheMinor;
    private final Set<CompactionProgress> progressSet = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    protected final InternalScannerFactory defaultScannerFactory = new InternalScannerFactory(){

        @Override
        public ScanType getScanType(CompactionRequestImpl request) {
            return request.isAllFiles() ? ScanType.COMPACT_DROP_DELETES : ScanType.COMPACT_RETAIN_DELETES;
        }

        @Override
        public InternalScanner createScanner(ScanInfo scanInfo, List<StoreFileScanner> scanners, ScanType scanType, FileDetails fd, long smallestReadPoint) throws IOException {
            return Compactor.this.createScanner(Compactor.this.store, scanInfo, scanners, scanType, smallestReadPoint, fd.earliestPutTs);
        }
    };

    Compactor(Configuration conf, HStore store) {
        this.conf = conf;
        this.store = store;
        this.compactionKVMax = this.conf.getInt("hbase.hstore.compaction.kv.max", 10);
        this.majorCompactionCompression = store.getColumnFamilyDescriptor() == null ? Compression.Algorithm.NONE : store.getColumnFamilyDescriptor().getMajorCompactionCompressionType();
        this.minorCompactionCompression = store.getColumnFamilyDescriptor() == null ? Compression.Algorithm.NONE : store.getColumnFamilyDescriptor().getMinorCompactionCompressionType();
        this.keepSeqIdPeriod = Math.max(this.conf.getInt("hbase.hstore.compaction.keep.seqId.period", 5), 5);
        this.dropCacheMajor = conf.getBoolean(MAJOR_COMPACTION_DROP_CACHE, true);
        this.dropCacheMinor = conf.getBoolean(MINOR_COMPACTION_DROP_CACHE, true);
    }

    private FileDetails getFileDetails(Collection<HStoreFile> filesToCompact, boolean allFiles, boolean major) throws IOException {
        FileDetails fd = new FileDetails();
        long oldestHFileTimestampToKeepMVCC = EnvironmentEdgeManager.currentTime() - 86400000L * (long)this.keepSeqIdPeriod;
        for (HStoreFile file : filesToCompact) {
            if (allFiles && file.getModificationTimestamp() < oldestHFileTimestampToKeepMVCC && fd.minSeqIdToKeep < file.getMaxMemStoreTS()) {
                fd.minSeqIdToKeep = file.getMaxMemStoreTS();
            }
            long seqNum = file.getMaxSequenceId();
            fd.maxSeqId = Math.max(fd.maxSeqId, seqNum);
            StoreFileReader r = file.getReader();
            if (r == null) {
                LOG.warn("Null reader for " + file.getPath());
                continue;
            }
            long keyCount = r.getEntries();
            fd.maxKeyCount += keyCount;
            Map<byte[], byte[]> fileInfo = r.loadFileInfo();
            FileDetails fileDetails = fd;
            fileDetails.totalCompactedFilesSize = fileDetails.totalCompactedFilesSize + r.length();
            byte[] tmp = null;
            if (r.isBulkLoaded()) {
                fd.maxMVCCReadpoint = Math.max(fd.maxMVCCReadpoint, r.getSequenceID());
            } else {
                tmp = fileInfo.get(HFile.Writer.MAX_MEMSTORE_TS_KEY);
                if (tmp != null) {
                    fd.maxMVCCReadpoint = Math.max(fd.maxMVCCReadpoint, Bytes.toLong(tmp));
                }
            }
            tmp = fileInfo.get(HFileInfo.MAX_TAGS_LEN);
            if (tmp != null) {
                fd.maxTagsLength = Math.max(fd.maxTagsLength, Bytes.toInt(tmp));
            }
            long earliestPutTs = 0L;
            if (allFiles) {
                tmp = fileInfo.get(HStoreFile.EARLIEST_PUT_TS);
                if (tmp == null) {
                    earliestPutTs = Long.MIN_VALUE;
                    fd.earliestPutTs = Long.MIN_VALUE;
                } else {
                    earliestPutTs = Bytes.toLong(tmp);
                    fd.earliestPutTs = Math.min(fd.earliestPutTs, earliestPutTs);
                }
            }
            fd.latestPutTs = (tmp = fileInfo.get(HStoreFile.TIMERANGE_KEY)) == null ? Long.MAX_VALUE : TimeRangeTracker.parseFrom(tmp).getMax();
            LOG.debug("Compacting {}, keycount={}, bloomtype={}, size={}, encoding={}, compression={}, seqNum={}{}", new Object[]{file.getPath() == null ? null : file.getPath().getName(), keyCount, r.getBloomFilterType().toString(), StringUtils.TraditionalBinaryPrefix.long2String((long)r.length(), (String)"", (int)1), r.getHFileReader().getDataBlockEncoding(), major ? this.majorCompactionCompression : this.minorCompactionCompression, seqNum, allFiles ? ", earliestPutTs=" + earliestPutTs : ""});
        }
        return fd;
    }

    private List<StoreFileScanner> createFileScanners(Collection<HStoreFile> filesToCompact, long smallestReadPoint, boolean useDropBehind) throws IOException {
        return StoreFileScanner.getScannersForCompaction(filesToCompact, useDropBehind, smallestReadPoint);
    }

    private long getSmallestReadPoint() {
        return this.store.getSmallestReadPoint();
    }

    protected final CreateStoreFileWriterParams createParams(FileDetails fd, boolean shouldDropBehind, boolean major, Consumer<Path> writerCreationTracker) {
        return CreateStoreFileWriterParams.create().maxKeyCount(fd.maxKeyCount).compression(major ? this.majorCompactionCompression : this.minorCompactionCompression).isCompaction(true).includeMVCCReadpoint(fd.maxMVCCReadpoint > 0L).includesTag(fd.maxTagsLength > 0).shouldDropBehind(shouldDropBehind).totalCompactedFilesSize(fd.totalCompactedFilesSize).writerCreationTracker(writerCreationTracker);
    }

    protected final StoreFileWriter createWriter(FileDetails fd, boolean shouldDropBehind, boolean major, Consumer<Path> writerCreationTracker) throws IOException {
        return this.store.getStoreEngine().createWriter(this.createParams(fd, shouldDropBehind, major, writerCreationTracker));
    }

    protected final StoreFileWriter createWriter(FileDetails fd, boolean shouldDropBehind, String fileStoragePolicy, boolean major, Consumer<Path> writerCreationTracker) throws IOException {
        return this.store.getStoreEngine().createWriter(this.createParams(fd, shouldDropBehind, major, writerCreationTracker).fileStoragePolicy(fileStoragePolicy));
    }

    private ScanInfo preCompactScannerOpen(CompactionRequestImpl request, ScanType scanType, User user) throws IOException {
        if (this.store.getCoprocessorHost() == null) {
            return this.store.getScanInfo();
        }
        return this.store.getCoprocessorHost().preCompactScannerOpen(this.store, scanType, request.getTracker(), request, user);
    }

    private InternalScanner postCompactScannerOpen(CompactionRequestImpl request, ScanType scanType, InternalScanner scanner, User user) throws IOException {
        if (this.store.getCoprocessorHost() == null) {
            return scanner;
        }
        return this.store.getCoprocessorHost().preCompact(this.store, scanner, scanType, request.getTracker(), request, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final List<Path> compact(CompactionRequestImpl request, InternalScannerFactory scannerFactory, CellSinkFactory<T> sinkFactory, ThroughputController throughputController, User user) throws IOException {
        CompactionProgress progress;
        CellSink writer;
        boolean finished;
        FileDetails fd;
        block17: {
            InternalScanner scanner;
            block16: {
                fd = this.getFileDetails(request.getFiles(), request.isAllFiles(), request.isMajor());
                long smallestReadPoint = this.getSmallestReadPoint();
                boolean dropCache = request.isMajor() || request.isAllFiles() ? this.dropCacheMajor : this.dropCacheMinor;
                scanner = null;
                finished = false;
                List<StoreFileScanner> scanners = this.createFileScanners(request.getFiles(), smallestReadPoint, dropCache);
                writer = null;
                progress = new CompactionProgress(fd.maxKeyCount);
                this.progressSet.add(progress);
                try {
                    ScanType scanType = scannerFactory.getScanType(request);
                    ScanInfo scanInfo = this.preCompactScannerOpen(request, scanType, user);
                    scanner = this.postCompactScannerOpen(request, scanType, scannerFactory.createScanner(scanInfo, scanners, scanType, fd, smallestReadPoint), user);
                    boolean cleanSeqId = false;
                    if (fd.minSeqIdToKeep > 0L && !this.store.getColumnFamilyDescriptor().isNewVersionBehavior()) {
                        smallestReadPoint = Math.min(fd.minSeqIdToKeep, smallestReadPoint);
                        cleanSeqId = true;
                    }
                    if (!(finished = this.performCompaction(fd, scanner, writer = (CellSink)sinkFactory.createWriter(scanner, fd, dropCache, request.isMajor(), request.getWriterCreationTracker()), smallestReadPoint, cleanSeqId, throughputController, request, progress))) {
                        throw new InterruptedIOException("Aborting compaction of store " + this.store + " in region " + this.store.getRegionInfo().getRegionNameAsString() + " because it was interrupted.");
                    }
                    if (scanner != null) break block16;
                }
                catch (Throwable throwable) {
                    if (scanner == null) {
                        for (StoreFileScanner sfs : scanners) {
                            sfs.close();
                        }
                    } else {
                        Closeables.close(scanner, true);
                    }
                    if (!finished) {
                        if (writer != null) {
                            this.abortWriter(writer);
                        }
                    } else {
                        this.store.updateCompactedMetrics(request.isMajor(), progress);
                    }
                    this.progressSet.remove(progress);
                    throw throwable;
                }
                for (StoreFileScanner sfs : scanners) {
                    sfs.close();
                }
                break block17;
            }
            Closeables.close(scanner, true);
        }
        if (!finished) {
            if (writer != null) {
                this.abortWriter(writer);
            }
        } else {
            this.store.updateCompactedMetrics(request.isMajor(), progress);
        }
        this.progressSet.remove(progress);
        assert (finished) : "We should have exited the method on all error paths";
        assert (writer != null) : "Writer should be non-null if no error";
        return this.commitWriter(writer, fd, request);
    }

    protected abstract List<Path> commitWriter(T var1, FileDetails var2, CompactionRequestImpl var3) throws IOException;

    protected abstract void abortWriter(T var1) throws IOException;

    protected boolean performCompaction(FileDetails fd, InternalScanner scanner, CellSink writer, long smallestReadPoint, boolean cleanSeqId, ThroughputController throughputController, CompactionRequestImpl request, CompactionProgress progress) throws IOException {
        assert (writer instanceof ShipperListener);
        long bytesWrittenProgressForLog = 0L;
        long bytesWrittenProgressForShippedCall = 0L;
        ArrayList<Cell> cells = new ArrayList<Cell>();
        long currentTime = EnvironmentEdgeManager.currentTime();
        long lastMillis = 0L;
        if (LOG.isDebugEnabled()) {
            lastMillis = currentTime;
        }
        CloseChecker closeChecker = new CloseChecker(this.conf, currentTime);
        String compactionName = ThroughputControlUtil.getNameForThrottling(this.store, "compaction");
        long now = 0L;
        ScannerContext scannerContext = ScannerContext.newBuilder().setBatchLimit(this.compactionKVMax).build();
        throughputController.start(compactionName);
        KeyValueScanner kvs = scanner instanceof KeyValueScanner ? (KeyValueScanner)((Object)scanner) : null;
        long shippedCallSizeLimit = (long)request.getFiles().size() * (long)this.store.getColumnFamilyDescriptor().getBlocksize();
        try {
            boolean hasMore;
            do {
                hasMore = scanner.next(cells, scannerContext);
                currentTime = EnvironmentEdgeManager.currentTime();
                if (LOG.isDebugEnabled()) {
                    now = currentTime;
                }
                if (closeChecker.isTimeLimit(this.store, currentTime)) {
                    progress.cancel();
                    boolean bl = false;
                    return bl;
                }
                Cell lastCleanCell = null;
                long lastCleanCellSeqId = 0L;
                for (Cell c : cells) {
                    if (cleanSeqId && c.getSequenceId() <= smallestReadPoint) {
                        lastCleanCell = c;
                        lastCleanCellSeqId = c.getSequenceId();
                        PrivateCellUtil.setSequenceId(c, 0L);
                    } else {
                        lastCleanCell = null;
                        lastCleanCellSeqId = 0L;
                    }
                    writer.append(c);
                    int len = c.getSerializedSize();
                    ++progress.currentCompactedKVs;
                    progress.totalCompactedSize += (long)len;
                    bytesWrittenProgressForShippedCall += (long)len;
                    if (LOG.isDebugEnabled()) {
                        bytesWrittenProgressForLog += (long)len;
                    }
                    throughputController.control(compactionName, len);
                    if (!closeChecker.isSizeLimit(this.store, len)) continue;
                    progress.cancel();
                    boolean bl = false;
                    return bl;
                }
                if (kvs != null && bytesWrittenProgressForShippedCall > shippedCallSizeLimit) {
                    if (lastCleanCell != null) {
                        PrivateCellUtil.setSequenceId(lastCleanCell, lastCleanCellSeqId);
                    }
                    ((ShipperListener)((Object)writer)).beforeShipped();
                    kvs.shipped();
                    bytesWrittenProgressForShippedCall = 0L;
                }
                if (lastCleanCell != null) {
                    PrivateCellUtil.setSequenceId(lastCleanCell, lastCleanCellSeqId);
                }
                if (LOG.isDebugEnabled() && now - lastMillis >= 60000L) {
                    String rate = String.format("%.2f", (double)bytesWrittenProgressForLog / 1024.0 / ((double)(now - lastMillis) / 1000.0));
                    LOG.debug("Compaction progress: {} {}, rate={} KB/sec, throughputController is {}", new Object[]{compactionName, progress, rate, throughputController});
                    lastMillis = now;
                    bytesWrittenProgressForLog = 0L;
                }
                cells.clear();
            } while (hasMore);
        }
        catch (InterruptedException e) {
            progress.cancel();
            throw new InterruptedIOException("Interrupted while control throughput of compacting " + compactionName);
        }
        finally {
            ((ShipperListener)((Object)writer)).beforeShipped();
            throughputController.finish(compactionName);
        }
        progress.complete();
        return true;
    }

    protected InternalScanner createScanner(HStore store, ScanInfo scanInfo, List<StoreFileScanner> scanners, ScanType scanType, long smallestReadPoint, long earliestPutTs) throws IOException {
        return new StoreScanner(store, scanInfo, scanners, scanType, smallestReadPoint, earliestPutTs);
    }

    protected InternalScanner createScanner(HStore store, ScanInfo scanInfo, List<StoreFileScanner> scanners, long smallestReadPoint, long earliestPutTs, byte[] dropDeletesFromRow, byte[] dropDeletesToRow) throws IOException {
        return new StoreScanner(store, scanInfo, scanners, smallestReadPoint, earliestPutTs, dropDeletesFromRow, dropDeletesToRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompactionProgress getProgress() {
        Set<CompactionProgress> set = this.progressSet;
        synchronized (set) {
            long totalCompactingKVs = 0L;
            long currentCompactedKVs = 0L;
            long totalCompactedSize = 0L;
            for (CompactionProgress progress : this.progressSet) {
                totalCompactingKVs += progress.totalCompactingKVs;
                currentCompactedKVs += progress.currentCompactedKVs;
                totalCompactedSize += progress.totalCompactedSize;
            }
            CompactionProgress result = new CompactionProgress(totalCompactingKVs);
            result.currentCompactedKVs = currentCompactedKVs;
            result.totalCompactedSize = totalCompactedSize;
            return result;
        }
    }

    public boolean isCompacting() {
        return !this.progressSet.isEmpty();
    }

    protected static interface InternalScannerFactory {
        public ScanType getScanType(CompactionRequestImpl var1);

        public InternalScanner createScanner(ScanInfo var1, List<StoreFileScanner> var2, ScanType var3, FileDetails var4, long var5) throws IOException;
    }

    protected static class FileDetails {
        public long maxKeyCount = 0L;
        public long earliestPutTs = Long.MAX_VALUE;
        public long latestPutTs = Long.MAX_VALUE;
        public long maxSeqId = 0L;
        public long maxMVCCReadpoint = 0L;
        public int maxTagsLength = 0;
        public long minSeqIdToKeep = 0L;
        private long totalCompactedFilesSize = 0L;

        protected FileDetails() {
        }
    }

    protected static interface CellSinkFactory<S> {
        public S createWriter(InternalScanner var1, FileDetails var2, boolean var3, boolean var4, Consumer<Path> var5) throws IOException;
    }
}

