/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class RoundRobinTableInputFormat
extends TableInputFormat {
    private Boolean hbaseRegionsizecalculatorEnableOriginalValue = null;
    static String HBASE_REGIONSIZECALCULATOR_ENABLE = "hbase.regionsizecalculator.enable";

    @Override
    public List<InputSplit> getSplits(JobContext context) throws IOException {
        try {
            this.configure();
            List<InputSplit> list = this.roundRobin(this.getSuperSplits(context));
            return list;
        }
        finally {
            this.unconfigure();
        }
    }

    List<InputSplit> getSuperSplits(JobContext context) throws IOException {
        return super.getSplits(context);
    }

    List<InputSplit> roundRobin(List<InputSplit> inputs) throws IOException {
        if (inputs == null || inputs.isEmpty()) {
            return inputs;
        }
        ArrayList<InputSplit> result = new ArrayList<InputSplit>(inputs.size());
        HashMap<String, List> regionServerSplits = new HashMap<String, List>();
        for (InputSplit is : inputs) {
            String regionServer;
            if (is instanceof TableSplit && (regionServer = ((TableSplit)is).getRegionLocation()) != null && !StringUtils.isBlank(regionServer)) {
                regionServerSplits.computeIfAbsent(regionServer, k -> new ArrayList()).add(is);
                continue;
            }
            result.add(is);
        }
        while (!regionServerSplits.isEmpty()) {
            Iterator iter = regionServerSplits.values().iterator();
            while (iter.hasNext()) {
                List inputSplitListForRegion = (List)iter.next();
                if (!inputSplitListForRegion.isEmpty()) {
                    result.add((InputSplit)inputSplitListForRegion.remove(0));
                }
                if (!inputSplitListForRegion.isEmpty()) continue;
                iter.remove();
            }
        }
        return result;
    }

    void configure() {
        if (this.getConf().get(HBASE_REGIONSIZECALCULATOR_ENABLE) != null) {
            this.hbaseRegionsizecalculatorEnableOriginalValue = this.getConf().getBoolean(HBASE_REGIONSIZECALCULATOR_ENABLE, true);
        }
        this.getConf().setBoolean(HBASE_REGIONSIZECALCULATOR_ENABLE, false);
    }

    void unconfigure() {
        if (this.hbaseRegionsizecalculatorEnableOriginalValue == null) {
            this.getConf().unset(HBASE_REGIONSIZECALCULATOR_ENABLE);
        } else {
            this.getConf().setBoolean(HBASE_REGIONSIZECALCULATOR_ENABLE, this.hbaseRegionsizecalculatorEnableOriginalValue.booleanValue());
        }
    }

    public static void main(String[] args) throws IOException {
        RoundRobinTableInputFormat tif = new RoundRobinTableInputFormat();
        Configuration configuration = HBaseConfiguration.create();
        configuration.setBoolean("hbase.regionsizecalculator.enable", false);
        configuration.set("hbase.zookeeper.quorum", System.getProperty("hbase.zookeeper.quorum", "localhost"));
        configuration.set("hbase.mapreduce.inputtable", args[0]);
        tif.setConf(configuration);
        List<InputSplit> splits = ((TableInputFormat)tif).getSplits((JobContext)new JobContextImpl(configuration, new JobID()));
        for (InputSplit split : splits) {
            System.out.println(split);
        }
    }
}

