/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.executor;

import java.io.IOException;
import java.io.Writer;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.ExecutorType;
import org.apache.hadoop.hbase.monitoring.ThreadMonitoring;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ListeningScheduledExecutorService;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ExecutorService {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorService.class);
    private final ConcurrentHashMap<String, Executor> executorMap = new ConcurrentHashMap();
    private final String servername;
    private final ListeningScheduledExecutorService delayedSubmitTimer = MoreExecutors.listeningDecorator(Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Event-Executor-Delay-Submit-Timer").build()));

    public ExecutorService(String servername) {
        this.servername = servername;
    }

    public void startExecutorService(ExecutorConfig config) {
        String name = config.getName();
        if (this.executorMap.get(name) != null) {
            throw new RuntimeException("An executor service with the name " + name + " is already running!");
        }
        Executor hbes = new Executor(config);
        if (this.executorMap.putIfAbsent(name, hbes) != null) {
            throw new RuntimeException("An executor service with the name " + name + " is already running (2)!");
        }
        LOG.debug("Starting executor service name=" + name + ", corePoolSize=" + hbes.threadPoolExecutor.getCorePoolSize() + ", maxPoolSize=" + hbes.threadPoolExecutor.getMaximumPoolSize());
    }

    boolean isExecutorServiceRunning(String name) {
        return this.executorMap.containsKey(name);
    }

    public void shutdown() {
        this.delayedSubmitTimer.shutdownNow();
        for (Map.Entry<String, Executor> entry : this.executorMap.entrySet()) {
            List<Runnable> wasRunning = entry.getValue().threadPoolExecutor.shutdownNow();
            if (wasRunning.isEmpty()) continue;
            LOG.info(entry.getValue() + " had " + wasRunning + " on shutdown");
        }
        this.executorMap.clear();
    }

    Executor getExecutor(ExecutorType type) {
        return this.getExecutor(type.getExecutorName(this.servername));
    }

    Executor getExecutor(String name) {
        return this.executorMap.get(name);
    }

    public ThreadPoolExecutor getExecutorThreadPool(ExecutorType type) {
        return this.getExecutor(type).getThreadPoolExecutor();
    }

    public ThreadPoolExecutor getExecutorLazily(ExecutorConfig config) {
        return this.executorMap.computeIfAbsent(config.getName(), executorName -> new Executor(config)).getThreadPoolExecutor();
    }

    public void submit(EventHandler eh) {
        Executor executor = this.getExecutor(eh.getEventType().getExecutorServiceType());
        if (executor == null) {
            LOG.error("Cannot submit [" + eh + "] because the executor is missing. Is this process shutting down?");
        } else {
            executor.submit(eh);
        }
    }

    public void delayedSubmit(EventHandler eh, long delay, TimeUnit unit) {
        ScheduledFuture future = this.delayedSubmitTimer.schedule(() -> this.submit(eh), delay, unit);
        future.addListener(() -> ExecutorService.lambda$delayedSubmit$2((ListenableFuture)((Object)future), eh), MoreExecutors.directExecutor());
    }

    public Map<String, ExecutorStatus> getAllExecutorStatuses() {
        HashMap<String, ExecutorStatus> ret = Maps.newHashMap();
        for (Map.Entry<String, Executor> e : this.executorMap.entrySet()) {
            ret.put(e.getKey(), e.getValue().getStatus());
        }
        return ret;
    }

    private static /* synthetic */ void lambda$delayedSubmit$2(ListenableFuture future, EventHandler eh) {
        try {
            future.get();
        }
        catch (Exception e) {
            LOG.error("Failed to submit the event handler {} to executor", (Object)eh, (Object)e);
        }
    }

    public static class RunningEventStatus {
        final ThreadInfo threadInfo;
        final EventHandler event;

        public RunningEventStatus(Thread t, EventHandler event) {
            this.threadInfo = ThreadMonitoring.getThreadInfo(t);
            this.event = event;
        }
    }

    public static class ExecutorStatus {
        final Executor executor;
        final List<EventHandler> queuedEvents;
        final List<RunningEventStatus> running;

        ExecutorStatus(Executor executor, List<EventHandler> queuedEvents, List<RunningEventStatus> running) {
            this.executor = executor;
            this.queuedEvents = queuedEvents;
            this.running = running;
        }

        public void dumpTo(Writer out, String indent) throws IOException {
            out.write(indent + "Status for executor: " + this.executor + "\n");
            out.write(indent + "=======================================\n");
            out.write(indent + this.queuedEvents.size() + " events queued, " + this.running.size() + " running\n");
            if (!this.queuedEvents.isEmpty()) {
                out.write(indent + "Queued:\n");
                for (EventHandler e : this.queuedEvents) {
                    out.write(indent + "  " + e + "\n");
                }
                out.write("\n");
            }
            if (!this.running.isEmpty()) {
                out.write(indent + "Running:\n");
                for (RunningEventStatus stat : this.running) {
                    out.write(indent + "  Running on thread '" + stat.threadInfo.getThreadName() + "': " + stat.event + "\n");
                    out.write(ThreadMonitoring.formatThreadInfo(stat.threadInfo, indent + "  "));
                    out.write("\n");
                }
            }
            out.flush();
        }
    }

    static class TrackingThreadPoolExecutor
    extends ThreadPoolExecutor {
        private ConcurrentMap<Thread, Runnable> running = Maps.newConcurrentMap();

        public TrackingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            this.running.remove(Thread.currentThread());
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            Runnable oldPut = this.running.put(t, r);
            assert (oldPut == null) : "inconsistency for thread " + t;
            super.beforeExecute(t, r);
        }

        public ConcurrentMap<Thread, Runnable> getRunningTasks() {
            return this.running;
        }
    }

    static class Executor {
        final TrackingThreadPoolExecutor threadPoolExecutor;
        final BlockingQueue<Runnable> q = new LinkedBlockingQueue<Runnable>();
        private final String name;
        private static final AtomicLong seqids = new AtomicLong(0L);
        private final long id = seqids.incrementAndGet();

        protected Executor(ExecutorConfig config) {
            this.name = config.getName();
            this.threadPoolExecutor = new TrackingThreadPoolExecutor(config.getCorePoolSize(), config.getCorePoolSize(), config.getKeepAliveTimeMillis(), TimeUnit.MILLISECONDS, this.q);
            this.threadPoolExecutor.allowCoreThreadTimeOut(config.allowCoreThreadTimeout());
            ThreadFactoryBuilder tfb = new ThreadFactoryBuilder();
            tfb.setNameFormat(this.name + "-%d");
            tfb.setDaemon(true);
            this.threadPoolExecutor.setThreadFactory(tfb.build());
        }

        void submit(EventHandler event) {
            this.threadPoolExecutor.execute(event);
        }

        TrackingThreadPoolExecutor getThreadPoolExecutor() {
            return this.threadPoolExecutor;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "-" + this.id + "-" + this.name;
        }

        public ExecutorStatus getStatus() {
            ArrayList<EventHandler> queuedEvents = Lists.newArrayList();
            for (Runnable r : this.q) {
                if (!(r instanceof EventHandler)) {
                    LOG.warn("Non-EventHandler " + r + " queued in " + this.name);
                    continue;
                }
                queuedEvents.add((EventHandler)r);
            }
            ArrayList<RunningEventStatus> running = Lists.newArrayList();
            for (Map.Entry e : this.threadPoolExecutor.getRunningTasks().entrySet()) {
                Runnable r = (Runnable)e.getValue();
                if (!(r instanceof EventHandler)) {
                    LOG.warn("Non-EventHandler " + r + " running in " + this.name);
                    continue;
                }
                running.add(new RunningEventStatus((Thread)e.getKey(), (EventHandler)r));
            }
            return new ExecutorStatus(this, queuedEvents, running);
        }
    }

    public class ExecutorConfig {
        public static final long KEEP_ALIVE_TIME_MILLIS_DEFAULT = 1000L;
        private int corePoolSize = -1;
        private boolean allowCoreThreadTimeout = false;
        private long keepAliveTimeMillis = 1000L;
        private ExecutorType executorType;

        public ExecutorConfig setExecutorType(ExecutorType type) {
            this.executorType = type;
            return this;
        }

        private ExecutorType getExecutorType() {
            return Preconditions.checkNotNull(this.executorType, "ExecutorType not set.");
        }

        public int getCorePoolSize() {
            return this.corePoolSize;
        }

        public ExecutorConfig setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
            return this;
        }

        public boolean allowCoreThreadTimeout() {
            return this.allowCoreThreadTimeout;
        }

        public ExecutorConfig setAllowCoreThreadTimeout(boolean allowCoreThreadTimeout) {
            this.allowCoreThreadTimeout = allowCoreThreadTimeout;
            return this;
        }

        public String getName() {
            return this.getExecutorType().getExecutorName(ExecutorService.this.servername);
        }

        public long getKeepAliveTimeMillis() {
            return this.keepAliveTimeMillis;
        }

        public ExecutorConfig setKeepAliveTimeMillis(long keepAliveTimeMillis) {
            this.keepAliveTimeMillis = keepAliveTimeMillis;
            return this;
        }
    }
}

