/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.lucene;

import java.time.Instant;
import java.util.Date;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.tinkerpop.shaded.jackson.databind.util.StdDateFormat;
import org.janusgraph.diskstorage.indexing.KeyInformation;
import org.janusgraph.graphdb.database.serialize.AttributeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumericTranslationQueryParser
extends QueryParser {
    private static final Logger log = LoggerFactory.getLogger(NumericTranslationQueryParser.class);
    private final KeyInformation.StoreRetriever storeRetriever;

    public NumericTranslationQueryParser(KeyInformation.StoreRetriever storeRetriever, String field, Analyzer analyzer) {
        super(field, analyzer);
        this.storeRetriever = storeRetriever;
    }

    protected Query newRangeQuery(String field, String start, String end, boolean startInclusive, boolean endInclusive) {
        Class<?> dataType = this.getKeyDataType(field);
        if (this.isPossibleRangeQuery(dataType)) {
            try {
                return this.buildNumericRangeQuery(field, dataType, start, end, startInclusive, endInclusive);
            }
            catch (NumberFormatException e) {
                this.printNumberFormatException(field, dataType, e);
            }
        }
        return super.newRangeQuery(field, start, end, startInclusive, endInclusive);
    }

    protected Query newFieldQuery(Analyzer analyzer, String field, String queryText, boolean quoted) throws ParseException {
        Class<?> dataType = this.getKeyDataType(field);
        if (this.isPossibleRangeQuery(dataType) || Boolean.class.equals(dataType)) {
            try {
                return this.buildNumericQuery(field, queryText, dataType);
            }
            catch (NumberFormatException e) {
                this.printNumberFormatException(field, dataType, e);
            }
        }
        return super.newFieldQuery(analyzer, field, queryText, quoted);
    }

    protected Query newWildcardQuery(Term t) {
        if (t.field() == null) {
            return super.newWildcardQuery(t);
        }
        Class<?> dataType = this.getKeyDataType(t.field());
        if (this.isPossibleRangeQuery(dataType) || Boolean.class.equals(dataType)) {
            try {
                return this.buildNumericQuery(t.field(), t.text(), dataType);
            }
            catch (NumberFormatException e) {
                this.printNumberFormatException(t.field(), dataType, e);
            }
        }
        return super.newWildcardQuery(t);
    }

    private Query buildNumericRangeQuery(String field, Class<?> type, String start, String end, boolean includeLower, boolean includeUpper) {
        double max;
        if (AttributeUtils.isWholeNumber(type) || this.isTemporalType(type)) {
            long max2;
            long min;
            if (this.isTemporalType(type)) {
                min = this.isMatchAll(start) ? Long.MIN_VALUE : this.parseDate(start).getTime();
                max2 = this.isMatchAll(end) ? Long.MAX_VALUE : this.parseDate(end).getTime();
            } else {
                min = this.isMatchAll(start) ? Long.MIN_VALUE : Long.parseLong(start);
                long l = max2 = this.isMatchAll(end) ? Long.MAX_VALUE : Long.parseLong(end);
            }
            if (!includeLower) {
                min = Math.addExact(min, 1L);
            }
            if (!includeUpper) {
                max2 = Math.addExact(max2, -1L);
            }
            return LongPoint.newRangeQuery((String)field, (long)min, (long)max2);
        }
        double min = this.isMatchAll(start) ? Double.NEGATIVE_INFINITY : Double.parseDouble(start);
        double d = max = this.isMatchAll(end) ? Double.POSITIVE_INFINITY : Double.parseDouble(end);
        if (!includeLower) {
            min = DoublePoint.nextUp((double)min);
        }
        if (!includeUpper) {
            max = DoublePoint.nextDown((double)max);
        }
        return DoublePoint.newRangeQuery((String)field, (double)min, (double)max);
    }

    private Query buildNumericQuery(String field, String value, Class<?> type) {
        Query query;
        if (AttributeUtils.isWholeNumber(type) || this.isTemporalType(type)) {
            query = this.isMatchAll(value) ? LongPoint.newRangeQuery((String)field, (long)Long.MIN_VALUE, (long)Long.MAX_VALUE) : (this.isTemporalType(type) ? LongPoint.newExactQuery((String)field, (long)this.parseDate(value).getTime()) : LongPoint.newExactQuery((String)field, (long)Long.parseLong(value)));
        } else {
            if (Boolean.class.isAssignableFrom(type)) {
                if (this.isMatchAll(value)) {
                    return IntPoint.newRangeQuery((String)field, (int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE);
                }
                return IntPoint.newExactQuery((String)field, (int)(Boolean.parseBoolean(value) ? 1 : 0));
            }
            query = this.isMatchAll(value) ? DoublePoint.newRangeQuery((String)field, (double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY) : DoublePoint.newExactQuery((String)field, (double)Double.parseDouble(value));
        }
        return query;
    }

    private Class<?> getKeyDataType(String field) {
        KeyInformation keyInformation = this.storeRetriever.get(field);
        if (keyInformation == null) {
            log.warn(String.format("Could not find key information for: %s", field));
            return null;
        }
        return keyInformation.getDataType();
    }

    private Date parseDate(String value) {
        try {
            return StdDateFormat.instance.parse(value);
        }
        catch (java.text.ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isPossibleRangeQuery(Class<?> dataType) {
        if (dataType == null) {
            return false;
        }
        return Number.class.isAssignableFrom(dataType) || this.isTemporalType(dataType);
    }

    private boolean isTemporalType(Class<?> dataType) {
        return Date.class.equals(dataType) || Instant.class.equals(dataType);
    }

    private boolean isMatchAll(String value) {
        return value == null || "*".equals(value);
    }

    private void printNumberFormatException(String field, Class<?> dataType, NumberFormatException e) {
        log.warn("Expected Number type for " + field + ":" + dataType, (Throwable)e);
    }
}

