/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.io.binary;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.graphdb.tinkerpop.io.binary.GraphBinaryType;
import org.janusgraph.graphdb.tinkerpop.io.binary.JanusGraphTypeSerializer;
import org.janusgraph.graphdb.tinkerpop.io.binary.geoshape.BoxSerializer;
import org.janusgraph.graphdb.tinkerpop.io.binary.geoshape.CircleSerializer;
import org.janusgraph.graphdb.tinkerpop.io.binary.geoshape.GeometryCollectionSerializer;
import org.janusgraph.graphdb.tinkerpop.io.binary.geoshape.GeoshapeTypeSerializer;
import org.janusgraph.graphdb.tinkerpop.io.binary.geoshape.LineSerializer;
import org.janusgraph.graphdb.tinkerpop.io.binary.geoshape.MultiLineSerializer;
import org.janusgraph.graphdb.tinkerpop.io.binary.geoshape.MultiPointSerializer;
import org.janusgraph.graphdb.tinkerpop.io.binary.geoshape.MultiPolygonSerializer;
import org.janusgraph.graphdb.tinkerpop.io.binary.geoshape.PointSerializer;
import org.janusgraph.graphdb.tinkerpop.io.binary.geoshape.PolygonSerializer;

public class GeoshapeGraphBinarySerializer
extends JanusGraphTypeSerializer<Geoshape> {
    private final Map<Integer, GeoshapeTypeSerializer> serializerByGeoshapeTypeCode = new HashMap<Integer, GeoshapeTypeSerializer>();
    private final Map<Geoshape.Type, GeoshapeTypeSerializer> serializerByGeoshapeType = new HashMap<Geoshape.Type, GeoshapeTypeSerializer>();

    public GeoshapeGraphBinarySerializer() {
        super(GraphBinaryType.Geoshape);
        this.serializerByGeoshapeTypeCode.put(0, new PointSerializer());
        this.serializerByGeoshapeTypeCode.put(1, new CircleSerializer());
        this.serializerByGeoshapeTypeCode.put(2, new BoxSerializer());
        this.serializerByGeoshapeTypeCode.put(3, new LineSerializer());
        this.serializerByGeoshapeTypeCode.put(4, new PolygonSerializer());
        this.serializerByGeoshapeTypeCode.put(5, new MultiPointSerializer());
        this.serializerByGeoshapeTypeCode.put(6, new MultiLineSerializer());
        this.serializerByGeoshapeTypeCode.put(7, new MultiPolygonSerializer());
        this.serializerByGeoshapeTypeCode.put(8, new GeometryCollectionSerializer());
        this.serializerByGeoshapeType.put(Geoshape.Type.POINT, new PointSerializer());
        this.serializerByGeoshapeType.put(Geoshape.Type.CIRCLE, new CircleSerializer());
        this.serializerByGeoshapeType.put(Geoshape.Type.BOX, new BoxSerializer());
        this.serializerByGeoshapeType.put(Geoshape.Type.LINE, new LineSerializer());
        this.serializerByGeoshapeType.put(Geoshape.Type.POLYGON, new PolygonSerializer());
        this.serializerByGeoshapeType.put(Geoshape.Type.MULTIPOINT, new MultiPointSerializer());
        this.serializerByGeoshapeType.put(Geoshape.Type.MULTILINESTRING, new MultiLineSerializer());
        this.serializerByGeoshapeType.put(Geoshape.Type.MULTIPOLYGON, new MultiPolygonSerializer());
        this.serializerByGeoshapeType.put(Geoshape.Type.GEOMETRYCOLLECTION, new GeometryCollectionSerializer());
    }

    @Override
    public Geoshape readNonNullableValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        byte formatVersion = buffer.readByte();
        if (formatVersion != 2) {
            throw new SerializationException("Geoshape format " + formatVersion + " not supported");
        }
        int geoshapeTypeCode = buffer.readInt();
        GeoshapeTypeSerializer serializer = this.serializerByGeoshapeTypeCode.get(geoshapeTypeCode);
        if (serializer == null) {
            throw new SerializationException("Geoshape type code " + geoshapeTypeCode + " not supported");
        }
        return serializer.readNonNullableGeoshapeValue(buffer, context);
    }

    @Override
    public void writeNonNullableValue(Geoshape geoshape, Buffer buffer, GraphBinaryWriter context) throws IOException {
        Geoshape.Type type = geoshape.getType();
        GeoshapeTypeSerializer serializer = this.serializerByGeoshapeType.get((Object)type);
        if (serializer == null) {
            throw new SerializationException("Geoshape type " + (Object)((Object)type) + " not supported");
        }
        buffer.writeByte(2);
        serializer.writeNonNullableValue(geoshape, buffer, context);
    }
}

