/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.FileEntry;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.ManifestSuccessData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestCommitterSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.AbstractJobOrTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.apache.hadoop.thirdparty.com.google.common.collect.Iterables;
import org.apache.hadoop.util.functional.TaskPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameFilesStage
extends AbstractJobOrTaskStage<Pair<List<TaskManifest>, Set<Path>>, ManifestSuccessData> {
    private static final Logger LOG = LoggerFactory.getLogger(RenameFilesStage.class);
    private final List<FileEntry> filesCommitted = new ArrayList<FileEntry>();
    private long totalFileSize = 0L;
    private Set<Path> createdDirectories;

    public RenameFilesStage(StageConfig stageConfig) {
        super(false, stageConfig, "job_stage_rename_files", true);
    }

    public synchronized List<FileEntry> getFilesCommitted() {
        return this.filesCommitted;
    }

    public synchronized long getTotalFileSize() {
        return this.totalFileSize;
    }

    @Override
    protected ManifestSuccessData executeStage(Pair<List<TaskManifest>, Set<Path>> args) throws IOException {
        List taskManifests = (List)args.getLeft();
        this.createdDirectories = (Set)args.getRight();
        ManifestSuccessData success = ManifestCommitterSupport.createManifestOutcome(this.getStageConfig(), "committer_commit_job");
        int manifestCount = taskManifests.size();
        LOG.info("{}: Executing Manifest Job Commit with {} manifests in {}", new Object[]{this.getName(), manifestCount, this.getTaskManifestDir()});
        Iterable filesToCommit = Iterables.concat((Iterable)taskManifests.stream().map(TaskManifest::getFilesToCommit).collect(Collectors.toList()));
        TaskPool.foreach((Iterable)filesToCommit).executeWith(this.getIOProcessors()).stopOnFailure().run(this::commitOneFile);
        List<FileEntry> committed = this.getFilesCommitted();
        LOG.info("{}: Files committed: {}. Total size {}", new Object[]{this.getName(), committed.size(), this.getTotalFileSize()});
        success.setFilenamePaths(committed.subList(0, Math.min(committed.size(), 100)).stream().map(FileEntry::getDestPath).collect(Collectors.toList()));
        success.setSuccess(true);
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitOneFile(FileEntry entry) throws IOException {
        this.updateAuditContext("job_stage_rename_files");
        this.progress();
        boolean deleteDest = this.getStageConfig().getDeleteTargetPaths() && !this.createdDirectories.contains(entry.getDestPath().getParent());
        this.commitFile(entry, deleteDest);
        RenameFilesStage renameFilesStage = this;
        synchronized (renameFilesStage) {
            this.filesCommitted.add(entry);
            this.totalFileSize += entry.getSize();
        }
    }
}

