/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.io.IOException;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;

public final class GraphSONUtil {
    private GraphSONUtil() {
    }

    public static void writeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        GraphSONUtil.writeWithType(null, object, jsonGenerator, serializerProvider, typeSerializer);
    }

    public static void writeWithType(String key, Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        JsonSerializer serializer = serializerProvider.findValueSerializer(object.getClass(), null);
        if (typeSerializer != null) {
            if (key != null && !key.isEmpty()) {
                jsonGenerator.writeFieldName(key);
            }
            serializer.serializeWithType(object, jsonGenerator, serializerProvider, typeSerializer);
        } else {
            if (key != null && !key.isEmpty()) {
                jsonGenerator.writeFieldName(key);
            }
            serializer.serialize(object, jsonGenerator, serializerProvider);
        }
    }

    public static void writeStartObject(Object o, JsonGenerator jsonGenerator, TypeSerializer typeSerializer) throws IOException {
        if (typeSerializer != null) {
            typeSerializer.writeTypePrefixForObject(o, jsonGenerator);
        } else {
            jsonGenerator.writeStartObject();
        }
    }

    public static void writeEndObject(Object o, JsonGenerator jsonGenerator, TypeSerializer typeSerializer) throws IOException {
        if (typeSerializer != null) {
            typeSerializer.writeTypeSuffixForObject(o, jsonGenerator);
        } else {
            jsonGenerator.writeEndObject();
        }
    }

    public static void writeStartArray(Object o, JsonGenerator jsonGenerator, TypeSerializer typeSerializer) throws IOException {
        if (typeSerializer != null) {
            typeSerializer.writeTypePrefixForArray(o, jsonGenerator);
        } else {
            jsonGenerator.writeStartArray();
        }
    }

    public static void writeEndArray(Object o, JsonGenerator jsonGenerator, TypeSerializer typeSerializer) throws IOException {
        if (typeSerializer != null) {
            typeSerializer.writeTypeSuffixForArray(o, jsonGenerator);
        } else {
            jsonGenerator.writeEndArray();
        }
    }

    static void safeWriteObjectField(JsonGenerator jsonGenerator, String key, Object value) {
        try {
            jsonGenerator.writeObjectField(key, value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

