/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.PathProcessor;
import org.apache.tinkerpop.gremlin.process.traversal.step.Scoping;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.EmptyTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalProduct;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalRing;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class MathStep<S>
extends MapStep<S, Double>
implements ByModulating,
TraversalParent,
Scoping,
PathProcessor {
    private static final String CURRENT = "_";
    private final String equation;
    private final TinkerExpression expression;
    private TraversalRing<S, Number> traversalRing = new TraversalRing(new Traversal.Admin[0]);
    private Set<String> keepLabels;
    private static final String[] FUNCTIONS = new String[]{"abs", "acos", "asin", "atan", "cbrt", "ceil", "cos", "cosh", "exp", "floor", "log", "log10", "log2", "signum", "sin", "sinh", "sqrt", "tan", "tanh"};
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\b(?!" + String.join((CharSequence)"|", FUNCTIONS) + "|([0-9]+))([a-zA-Z_][a-zA-Z0-9_]*)\\b");

    public MathStep(Traversal.Admin traversal, String equation) {
        super(traversal);
        this.equation = equation;
        this.expression = new TinkerExpression(equation, MathStep.getVariables(this.equation));
    }

    @Override
    protected Traverser.Admin<Double> processNextStart() {
        Object traverser = this.starts.next();
        Expression localExpression = new Expression(this.expression.getExpression());
        boolean productive = true;
        for (String var : this.expression.getVariables()) {
            TraversalProduct product;
            TraversalProduct traversalProduct = product = var.equals(CURRENT) ? TraversalUtil.produce(traverser, this.traversalRing.next()) : TraversalUtil.produce(this.getNullableScopeValue(Pop.last, var, (Traverser.Admin<?>)traverser), this.traversalRing.next());
            if (!product.isProductive()) {
                productive = false;
                break;
            }
            Object o = product.get();
            if (!(o instanceof Number)) {
                throw new IllegalStateException(String.format("The variable %s for math() step must resolve to a Number - it is instead of type %s with value %s", var, Objects.isNull(o) ? "null" : o.getClass().getName(), o));
            }
            localExpression.setVariable(var, ((Number)o).doubleValue());
        }
        this.traversalRing.reset();
        return productive ? PathProcessor.processTraverserPathLabels(traverser.split(localExpression.evaluate(), this), this.keepLabels) : EmptyTraverser.instance();
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> selectTraversal) {
        this.traversalRing.addTraversal(this.integrateChild(selectTraversal));
    }

    @Override
    public PathProcessor.ElementRequirement getMaxRequirement() {
        return this.expression.getVariables().contains(CURRENT) && this.expression.getVariables().size() == 1 ? PathProcessor.ElementRequirement.ID : PathProcessor.super.getMaxRequirement();
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.equation, this.traversalRing);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.equation.hashCode() ^ this.traversalRing.hashCode();
    }

    public List<Traversal.Admin<S, Number>> getLocalChildren() {
        return this.traversalRing.getTraversals();
    }

    @Override
    public void reset() {
        super.reset();
        this.traversalRing.reset();
    }

    @Override
    public MathStep<S> clone() {
        MathStep clone = (MathStep)super.clone();
        clone.traversalRing = this.traversalRing.clone();
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.traversalRing.getTraversals().forEach(this::integrateChild);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT, TraverserRequirement.SIDE_EFFECTS);
    }

    @Override
    public Set<String> getScopeKeys() {
        if (this.expression.getVariables().contains(CURRENT)) {
            HashSet<String> temp = new HashSet<String>(this.expression.getVariables());
            temp.remove(CURRENT);
            return temp;
        }
        return this.expression.getVariables();
    }

    @Override
    public void setKeepLabels(Set<String> labels) {
        this.keepLabels = labels;
    }

    @Override
    public Set<String> getKeepLabels() {
        return this.keepLabels;
    }

    protected static final Set<String> getVariables(String equation) {
        Matcher matcher = VARIABLE_PATTERN.matcher(equation);
        LinkedHashSet<String> variables = new LinkedHashSet<String>();
        while (matcher.find()) {
            variables.add(matcher.group());
        }
        return variables;
    }

    public static class TinkerExpression
    implements Serializable {
        private transient Expression expression;
        private final String equation;
        private final Set<String> variables;

        public TinkerExpression(String equation, Set<String> variables) {
            this.variables = variables;
            this.equation = equation;
        }

        public Expression getExpression() {
            if (null == this.expression) {
                this.expression = new ExpressionBuilder(this.equation).variables(this.variables).implicitMultiplication(false).build();
            }
            return this.expression;
        }

        public Set<String> getVariables() {
            return this.variables;
        }
    }
}

