/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser;

import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.GraphBinaryMessageSerializerV1;
import org.apache.tinkerpop.gremlin.driver.ser.GraphSONMessageSerializerGremlinV1d0;
import org.apache.tinkerpop.gremlin.driver.ser.GraphSONMessageSerializerV2d0;
import org.apache.tinkerpop.gremlin.driver.ser.GraphSONMessageSerializerV3d0;

public enum Serializers {
    GRAPHSON("application/json"),
    GRAPHSON_V1D0("application/vnd.gremlin-v1.0+json"),
    GRAPHSON_V2D0("application/vnd.gremlin-v2.0+json"),
    GRAPHSON_V3D0("application/vnd.gremlin-v3.0+json"),
    GRAPHBINARY_V1D0("application/vnd.graphbinary-v1.0");

    private String value;

    private Serializers(String mimeType) {
        this.value = mimeType;
    }

    public String getValue() {
        return this.value;
    }

    public MessageSerializer<?> simpleInstance() {
        switch (this.value) {
            case "application/json": 
            case "application/vnd.gremlin-v3.0+json": {
                return new GraphSONMessageSerializerV3d0();
            }
            case "application/vnd.gremlin-v1.0+json": {
                return new GraphSONMessageSerializerGremlinV1d0();
            }
            case "application/vnd.gremlin-v2.0+json": {
                return new GraphSONMessageSerializerV2d0();
            }
            case "application/vnd.graphbinary-v1.0": {
                return new GraphBinaryMessageSerializerV1();
            }
        }
        throw new RuntimeException("Could not create a simple MessageSerializer instance of " + this.value);
    }
}

