/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphMultiQueryStep;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.JanusGraphMultiQueryStrategy;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;

public class JanusGraphUnusedMultiQueryRemovalStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> PRIORS = new HashSet<Class>(Arrays.asList(JanusGraphMultiQueryStrategy.class));
    private static final JanusGraphUnusedMultiQueryRemovalStrategy INSTANCE = new JanusGraphUnusedMultiQueryRemovalStrategy();

    private JanusGraphUnusedMultiQueryRemovalStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        boolean useMultiQuery;
        if (!traversal.getGraph().isPresent()) {
            return;
        }
        StandardJanusGraph janusGraph = JanusGraphTraversalUtil.getJanusGraph(traversal);
        if (janusGraph == null) {
            return;
        }
        Optional<StandardJanusGraphTx> tx = JanusGraphTraversalUtil.getJanusGraphTx(traversal);
        boolean bl = useMultiQuery = tx.isPresent() ? tx.get().getConfiguration().useMultiQuery() : janusGraph.getConfiguration().useMultiQuery();
        if (!useMultiQuery) {
            return;
        }
        List<JanusGraphMultiQueryStep> unusedMultiQuerySteps = this.findUnusedMultiQuerySteps(traversal);
        unusedMultiQuerySteps.forEach(multiQueryStep -> {
            NoOpBarrierStep generatedBarrierStep = multiQueryStep.getGeneratedBarrierStep();
            traversal.removeStep((Step)multiQueryStep);
            if (generatedBarrierStep != null) {
                traversal.removeStep((Step)generatedBarrierStep);
            }
        });
    }

    private List<JanusGraphMultiQueryStep> findUnusedMultiQuerySteps(Traversal.Admin<?, ?> traversal) {
        ArrayList<JanusGraphMultiQueryStep> unusedMultiQuerySteps = new ArrayList<JanusGraphMultiQueryStep>();
        traversal.getSteps().forEach(step -> {
            if (step instanceof JanusGraphMultiQueryStep && ((JanusGraphMultiQueryStep)((Object)step)).getClientSteps().isEmpty()) {
                unusedMultiQuerySteps.add((JanusGraphMultiQueryStep)((Object)step));
            }
        });
        return unusedMultiQuerySteps;
    }

    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPrior() {
        return PRIORS;
    }

    public static JanusGraphUnusedMultiQueryRemovalStrategy instance() {
        return INSTANCE;
    }
}

