/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.strategy;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DropStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphMultiQueryStep;
import org.janusgraph.graphdb.tinkerpop.optimize.step.MultiQueriable;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.JanusGraphLocalQueryOptimizerStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.JanusGraphStepStrategy;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;

public class JanusGraphMultiQueryStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> PRIORS = new HashSet<Class>(Arrays.asList(JanusGraphLocalQueryOptimizerStrategy.class, JanusGraphStepStrategy.class));
    private static final JanusGraphMultiQueryStrategy INSTANCE = new JanusGraphMultiQueryStrategy();

    private JanusGraphMultiQueryStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        boolean useMultiQuery;
        if (!traversal.getGraph().isPresent() || TraversalHelper.onGraphComputer(traversal) || !TraversalHelper.getStepsOfAssignableClassRecursively(DropStep.class, traversal).isEmpty()) {
            return;
        }
        StandardJanusGraph janusGraph = JanusGraphTraversalUtil.getJanusGraph(traversal);
        if (janusGraph == null) {
            return;
        }
        Optional<StandardJanusGraphTx> tx = JanusGraphTraversalUtil.getJanusGraphTx(traversal);
        boolean bl = useMultiQuery = tx.isPresent() ? tx.get().getConfiguration().useMultiQuery() : janusGraph.getConfiguration().useMultiQuery();
        if (!useMultiQuery) {
            return;
        }
        this.insertMultiQuerySteps(traversal, janusGraph.getConfiguration().limitBatchSize());
        this.configureMultiQueriables(traversal);
    }

    private void insertMultiQuerySteps(Traversal.Admin<?, ?> traversal, boolean limitBatchSize) {
        JanusGraphTraversalUtil.getSteps(JanusGraphTraversalUtil::isMultiQueryCompatibleStep, traversal).forEach(step -> {
            Optional<Step> multiQueryPosition = JanusGraphTraversalUtil.getLocalMultiQueryPositionForStep(step);
            if (multiQueryPosition.isPresent() && JanusGraphTraversalUtil.isLegalMultiQueryPosition(multiQueryPosition.get())) {
                JanusGraphMultiQueryStep multiQueryStep;
                Step pos = multiQueryPosition.get();
                if (limitBatchSize && !(multiQueryPosition.get() instanceof NoOpBarrierStep)) {
                    NoOpBarrierStep barrier = new NoOpBarrierStep(traversal);
                    TraversalHelper.insertBeforeStep((Step)barrier, (Step)pos, (Traversal.Admin)traversal);
                    pos = barrier;
                    multiQueryStep = new JanusGraphMultiQueryStep(traversal, limitBatchSize, barrier);
                } else {
                    multiQueryStep = new JanusGraphMultiQueryStep(traversal, limitBatchSize);
                }
                TraversalHelper.insertBeforeStep((Step)multiQueryStep, (Step)pos, (Traversal.Admin)traversal);
            }
        });
    }

    private void configureMultiQueriables(Traversal.Admin<?, ?> traversal) {
        TraversalHelper.getStepsOfAssignableClass(MultiQueriable.class, traversal).forEach(multiQueriable -> {
            List<Step> mqPositions = JanusGraphTraversalUtil.getAllMultiQueryPositionsForMultiQueriable(multiQueriable);
            for (Step mqPos : mqPositions) {
                if (JanusGraphTraversalUtil.isLegalMultiQueryPosition(mqPos)) continue;
                return;
            }
            multiQueriable.setUseMultiQuery(true);
            for (Step mqPos : mqPositions) {
                Optional<JanusGraphMultiQueryStep> multiQueryStep = JanusGraphTraversalUtil.getPreviousStepOfClass(JanusGraphMultiQueryStep.class, mqPos);
                multiQueryStep.ifPresent(mqs -> mqs.attachClient((MultiQueriable)multiQueriable));
            }
        });
    }

    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPrior() {
        return PRIORS;
    }

    public static JanusGraphMultiQueryStrategy instance() {
        return INSTANCE;
    }
}

