/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.step;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.janusgraph.core.BaseVertexQuery;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphMultiVertexQuery;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexQuery;
import org.janusgraph.graphdb.query.JanusGraphPredicateUtils;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.query.vertex.BasicVertexCentricQueryBuilder;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.step.HasStepFolder;
import org.janusgraph.graphdb.tinkerpop.optimize.step.MultiQueriable;
import org.janusgraph.graphdb.tinkerpop.optimize.step.fetcher.VertexStepBatchFetcher;
import org.janusgraph.graphdb.tinkerpop.profile.TP3ProfileWrapper;

public class JanusGraphVertexStep<E extends Element>
extends VertexStep<E>
implements HasStepFolder<Vertex, E>,
Profiling,
MultiQueriable<Vertex, E> {
    private boolean useMultiQuery = false;
    private boolean batchPropertyPrefetching = false;
    private VertexStepBatchFetcher vertexStepBatchFetcher;
    private QueryProfiler queryProfiler = QueryProfiler.NO_OP;
    private int txVertexCacheSize = 20000;
    private final ArrayList<HasContainer> hasContainers;
    private int limit;
    private final List<HasStepFolder.OrderEntry> orders = new ArrayList<HasStepFolder.OrderEntry>();

    public JanusGraphVertexStep(VertexStep<E> originalStep) {
        super(originalStep.getTraversal(), originalStep.getReturnClass(), originalStep.getDirection(), originalStep.getEdgeLabels());
        originalStep.getLabels().forEach(arg_0 -> ((JanusGraphVertexStep)this).addLabel(arg_0));
        if (originalStep instanceof JanusGraphVertexStep) {
            JanusGraphVertexStep originalJanusGraphVertexStep = (JanusGraphVertexStep)originalStep;
            this.setUseMultiQuery(originalJanusGraphVertexStep.useMultiQuery);
            this.hasContainers = originalJanusGraphVertexStep.hasContainers;
            this.limit = originalJanusGraphVertexStep.limit;
        } else {
            this.hasContainers = new ArrayList();
            this.limit = Integer.MAX_VALUE;
        }
    }

    @Override
    public void setUseMultiQuery(boolean useMultiQuery) {
        this.useMultiQuery = useMultiQuery;
        if (useMultiQuery && this.vertexStepBatchFetcher == null) {
            this.vertexStepBatchFetcher = new VertexStepBatchFetcher(this::makeQuery, this.getReturnClass());
        }
    }

    @Override
    public void registerFutureVertexForPrefetching(Vertex futureVertex) {
        if (this.useMultiQuery) {
            this.vertexStepBatchFetcher.registerFutureVertexForPrefetching(futureVertex);
        }
    }

    public void setBatchPropertyPrefetching(boolean batchPropertyPrefetching) {
        this.batchPropertyPrefetching = batchPropertyPrefetching;
    }

    public void setTxVertexCacheSize(int txVertexCacheSize) {
        this.txVertexCacheSize = txVertexCacheSize;
    }

    public <Q extends BaseVertexQuery> Q makeQuery(Q query) {
        query.labels(this.getEdgeLabels());
        query.direction(this.getDirection());
        for (HasContainer condition : this.hasContainers) {
            query.has(condition.getKey(), JanusGraphPredicateUtils.convert(condition.getBiPredicate()), condition.getValue());
        }
        for (HasStepFolder.OrderEntry order : this.orders) {
            query.orderBy(order.key, order.order);
        }
        if (this.limit != Integer.MAX_VALUE) {
            query.limit(this.limit);
        }
        ((BasicVertexCentricQueryBuilder)query).profiler(this.queryProfiler);
        return query;
    }

    protected Iterator<E> flatMap(Traverser.Admin<Vertex> traverser) {
        Iterable<JanusGraphElement> result;
        JanusGraphVertex vertexToFetchDataFor = JanusGraphTraversalUtil.getJanusGraphVertex(traverser);
        if (this.useMultiQuery) {
            result = (Iterable<JanusGraphElement>)this.vertexStepBatchFetcher.fetchData(this.getTraversal(), vertexToFetchDataFor);
        } else {
            JanusGraphVertexQuery<? extends JanusGraphVertexQuery> query = this.makeQuery(vertexToFetchDataFor.query());
            Iterable<JanusGraphElement> iterable = result = Vertex.class.isAssignableFrom(this.getReturnClass()) ? query.vertices() : query.edges();
        }
        if (this.batchPropertyPrefetching && this.txVertexCacheSize > 1) {
            HashSet<JanusGraphVertex> vertices = new HashSet<JanusGraphVertex>();
            for (JanusGraphElement v : result) {
                vertices.add((JanusGraphVertex)v);
                if (vertices.size() < this.txVertexCacheSize) continue;
                break;
            }
            if (vertices.size() > 1) {
                JanusGraphMultiVertexQuery<? extends JanusGraphMultiVertexQuery> propertyMultiQuery = JanusGraphTraversalUtil.getTx(this.traversal).multiQuery(vertices);
                ((BasicVertexCentricQueryBuilder)((Object)propertyMultiQuery)).profiler(this.queryProfiler);
                propertyMultiQuery.preFetch();
            }
        }
        return result.iterator();
    }

    @Override
    public void ensureAdditionalHasContainersCapacity(int additionalSize) {
        this.hasContainers.ensureCapacity(this.hasContainers.size() + additionalSize);
    }

    @Override
    public void addHasContainer(HasContainer hasContainer) {
        HasStepFolder.splitAndP(this.hasContainers, hasContainer);
    }

    @Override
    public List<HasContainer> addLocalHasContainersConvertingAndPContainers(TraversalParent parent, List<HasContainer> localHasContainers) {
        throw new UnsupportedOperationException("addLocalAll is not supported for graph vertex step.");
    }

    @Override
    public List<HasContainer> addLocalHasContainersSplittingAndPContainers(TraversalParent parent, Iterable<HasContainer> has) {
        throw new UnsupportedOperationException("addLocalAll is not supported for graph vertex step.");
    }

    @Override
    public void orderBy(String key, Order order) {
        this.orders.add(new HasStepFolder.OrderEntry(key, order));
    }

    @Override
    public void localOrderBy(TraversalParent parent, List<HasContainer> hasContainers, String key, Order order) {
        throw new UnsupportedOperationException("localOrderBy is not supported for graph vertex step.");
    }

    @Override
    public void setLimit(int low, int high) {
        Preconditions.checkArgument((low == 0 ? 1 : 0) != 0, (Object)"Offset is not supported for properties step.");
        this.limit = high;
    }

    @Override
    public void setLocalLimit(TraversalParent parent, List<HasContainer> hasContainers, int low, int high) {
        throw new UnsupportedOperationException("setLocalLimit is not supported for graph vertex step.");
    }

    @Override
    public int getLowLimit() {
        throw new UnsupportedOperationException("getLowLimit is not supported for properties step.");
    }

    @Override
    public int getLocalLowLimit(TraversalParent parent, List<HasContainer> hasContainers) {
        throw new UnsupportedOperationException("getLocalLowLimit is not supported for properties step.");
    }

    @Override
    public int getHighLimit() {
        return this.limit;
    }

    @Override
    public int getLocalHighLimit(TraversalParent parent, List<HasContainer> hasContainers) {
        throw new UnsupportedOperationException("getLocalHighLimit is not supported for graph vertex step.");
    }

    public String toString() {
        return this.hasContainers.isEmpty() ? super.toString() : StringFactory.stepString((Step)this, (Object[])new Object[]{this.hasContainers});
    }

    public void setMetrics(MutableMetrics metrics) {
        this.queryProfiler = new TP3ProfileWrapper(metrics);
    }
}

