/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.procedure2.RSProcedureCallable;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RSProcedureHandler
extends EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RSProcedureHandler.class);
    private final long procId;
    private final RSProcedureCallable callable;

    public RSProcedureHandler(HRegionServer rs, long procId, RSProcedureCallable callable) {
        super(rs, callable.getEventType());
        this.procId = procId;
        this.callable = callable;
    }

    @Override
    public void process() {
        Throwable error = null;
        try {
            this.callable.call();
            ((HRegionServer)this.server).remoteProcedureComplete(this.procId, error);
        }
        catch (Throwable t) {
            try {
                LOG.error("pid=" + this.procId, t);
                error = t;
                ((HRegionServer)this.server).remoteProcedureComplete(this.procId, error);
            }
            catch (Throwable throwable) {
                ((HRegionServer)this.server).remoteProcedureComplete(this.procId, error);
                throw throwable;
            }
        }
    }
}

