/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.http.api_v1.cluster_metrics.resource;

import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.inject.Inject;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hbase.thirdparty.javax.ws.rs.GET;
import org.apache.hbase.thirdparty.javax.ws.rs.Path;
import org.apache.hbase.thirdparty.javax.ws.rs.Produces;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
@Path(value="admin/cluster_metrics")
@Produces(value={"application/json"})
public class ClusterMetricsResource {
    final Connection connection;

    @Inject
    public ClusterMetricsResource(MasterServices master) throws IOException {
        this.connection = master.getConnection();
    }

    private ClusterMetrics get(EnumSet<ClusterMetrics.Option> fields) throws IOException {
        try (Admin admin = this.connection.getAdmin();){
            ClusterMetrics clusterMetrics = admin.getClusterMetrics(fields);
            return clusterMetrics;
        }
    }

    @GET
    @Path(value="/")
    public org.apache.hadoop.hbase.master.http.api_v1.cluster_metrics.model.ClusterMetrics getBaseMetrics() throws IOException {
        EnumSet<ClusterMetrics.Option> fields = EnumSet.of(ClusterMetrics.Option.HBASE_VERSION, ClusterMetrics.Option.CLUSTER_ID, ClusterMetrics.Option.MASTER, ClusterMetrics.Option.BACKUP_MASTERS);
        return org.apache.hadoop.hbase.master.http.api_v1.cluster_metrics.model.ClusterMetrics.from(this.get(fields));
    }

    @GET
    @Path(value="/live_servers")
    public Collection<ServerMetrics> getLiveServers() throws IOException {
        return this.get(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().values();
    }

    @GET
    @Path(value="/dead_servers")
    public List<ServerName> getDeadServers() throws IOException {
        return this.get(EnumSet.of(ClusterMetrics.Option.DEAD_SERVERS)).getDeadServerNames();
    }
}

