/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.function.slice;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import io.vavr.concurrent.Future;
import io.vavr.control.Try;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.cql.CQLColValGetter;
import org.janusgraph.diskstorage.cql.CQLKeyColumnValueStore;
import org.janusgraph.diskstorage.cql.function.slice.AbstractCQLSliceFunction;

public class CQLExecutorServiceSliceFunction
extends AbstractCQLSliceFunction {
    private final CQLColValGetter getter;
    private final ExecutorService executorService;

    public CQLExecutorServiceSliceFunction(CqlSession session, PreparedStatement getSlice, CQLColValGetter getter, ExecutorService executorService) {
        super(session, getSlice);
        this.getter = getter;
        this.executorService = executorService;
    }

    @Override
    protected EntryList getSlice(CompletableFuture<AsyncResultSet> completableFutureSlice) throws BackendException {
        Future result = Future.fromJavaFuture((Executor)this.executorService, completableFutureSlice).map(resultSet -> CQLExecutorServiceSliceFunction.fromResultSet(resultSet, this.getter));
        this.interruptibleWait(result);
        return (EntryList)((Try)result.getValue().get()).getOrElseThrow(CQLKeyColumnValueStore.EXCEPTION_MAPPER);
    }

    private void interruptibleWait(Future<?> result) throws PermanentBackendException {
        try {
            result.await();
        }
        catch (Exception e) {
            if (e.getCause() instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new PermanentBackendException((Throwable)e);
        }
    }
}

