/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.pkgtest;

import com.google.common.collect.ImmutableMap;
import java.net.Socket;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.remote.DriverRemoteConnection;
import org.apache.tinkerpop.gremlin.driver.ser.GraphBinaryMessageSerializerV1;
import org.apache.tinkerpop.gremlin.driver.ser.GraphSONMessageSerializerV3d0;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.traversal.AnonymousTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.janusgraph.graphdb.tinkerpop.JanusGraphIoRegistry;
import org.janusgraph.pkgtest.JanusGraphAssemblyBaseIT;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

public abstract class AbstractJanusGraphAssemblyIT
extends JanusGraphAssemblyBaseIT {
    protected abstract String getConfigPath();

    protected String getLocalSparkGraphConfigPath() {
        return null;
    }

    protected abstract String getServerConfigPath();

    protected Duration getDefaultTimeout() {
        return Duration.ofSeconds(30L);
    }

    @Test
    public void testSingleVertexInteractionAgainstGremlinSh() throws Exception {
        this.unzipAndRunExpect("single-vertex.expect.vm", this.getConfigPath(), this.getGraphName(), false, false);
    }

    @Test
    @Tag(value="FULL_TESTS")
    public void testSingleVertexInteractionAgainstGremlinShFull() throws Exception {
        this.unzipAndRunExpect("single-vertex.expect.vm", this.getConfigPath(), this.getGraphName(), true, false);
    }

    @Test
    public void testGettingStartedAgainstGremlinSh() throws Exception {
        this.unzipAndRunExpect("getting-started.expect.vm", this.getConfigPath(), this.getGraphName(), false, false);
    }

    @Test
    @Tag(value="FULL_TESTS")
    public void testGettingStartedAgainstGremlinShFull() throws Exception {
        this.unzipAndRunExpect("getting-started.expect.vm", this.getConfigPath(), this.getGraphName(), true, false);
    }

    @Test
    public void testJanusGraphServerGremlin() throws Exception {
        this.testJanusGraphServer(false);
    }

    @Test
    public void testSparkGraphComputerTraversalLocal() throws Exception {
        this.unzipAndRunExpect("spark-graph-computer.expect.vm", this.getConfigPath(), this.getLocalSparkGraphConfigPath(), this.getGraphName(), false, false);
    }

    @Test
    @Tag(value="FULL_TESTS")
    public void testJanusGraphServerGremlinFull() throws Exception {
        this.testJanusGraphServer(true);
    }

    protected MessageSerializer createGraphSONMessageSerializer() {
        return new GraphSONMessageSerializerV3d0(GraphSONMapper.build().addRegistry((IoRegistry)JanusGraphIoRegistry.instance()));
    }

    protected MessageSerializer createGraphBinaryMessageSerializerV1() {
        GraphBinaryMessageSerializerV1 serializer = new GraphBinaryMessageSerializerV1();
        HashMap<String, List<String>> config = new HashMap<String, List<String>>();
        config.put("ioRegistries", Collections.singletonList(JanusGraphIoRegistry.class.getName()));
        serializer.configure(config, Collections.emptyMap());
        return serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean serverListening(String host, int port) {
        Socket s = null;
        try {
            s = new Socket(host, port);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void testServerUsingTraversalSource(GraphTraversalSource g) {
        g.addV("Test").iterate();
        List vertices = g.V(new Object[0]).hasLabel("Test", new String[0]).toList();
        Assertions.assertNotEquals((int)0, (int)vertices.size());
    }

    protected void runTraversalAgainstServer(MessageSerializer serializer) throws Exception {
        Cluster cluster = Cluster.build((String)"localhost").port(8182).serializer(serializer).create();
        GraphTraversalSource g = (GraphTraversalSource)AnonymousTraversalSource.traversal().withRemote((RemoteConnection)DriverRemoteConnection.using((Cluster)cluster, (String)"g"));
        this.testServerUsingTraversalSource(g);
    }

    protected void testJanusGraphServer(boolean full) throws Exception {
        boolean debug = false;
        ImmutableMap contextVars = ImmutableMap.of((Object)"janusgraphServerConfig", (Object)this.getServerConfigPath());
        this.unzipAndRunExpect("janusgraph-server-sh.before.expect.vm", (Map<String, String>)contextVars, full, false);
        Assertions.assertTimeout((Duration)this.getDefaultTimeout(), () -> {
            while (!AbstractJanusGraphAssemblyIT.serverListening("localhost", 8182)) {
                Thread.sleep(1000L);
            }
        });
        this.runTraversalAgainstServer(this.createGraphSONMessageSerializer());
        this.runTraversalAgainstServer(this.createGraphBinaryMessageSerializerV1());
        this.parseTemplateAndRunExpect("remote-console.expect.vm", Collections.emptyMap(), full, false);
        this.parseTemplateAndRunExpect("janusgraph-server-sh.after.expect.vm", (Map<String, String>)contextVars, full, false);
    }
}

