/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.relations;

import java.io.Serializable;
import java.util.Arrays;
import org.janusgraph.util.encoding.LongEncoding;

public final class RelationIdentifier
implements Serializable {
    public static final String TOSTRING_DELIMITER = "-";
    private final Object outVertexId;
    private final long typeId;
    private final long relationId;
    private final Object inVertexId;

    private RelationIdentifier() {
        this.outVertexId = null;
        this.typeId = 0L;
        this.relationId = 0L;
        this.inVertexId = null;
    }

    public RelationIdentifier(Object outVertexId, long typeId, long relationId, Object inVertexId) {
        this.outVertexId = outVertexId;
        this.typeId = typeId;
        this.relationId = relationId;
        this.inVertexId = inVertexId;
    }

    public long getRelationId() {
        return this.relationId;
    }

    public long getTypeId() {
        return this.typeId;
    }

    public Object getOutVertexId() {
        return this.outVertexId;
    }

    public Object getInVertexId() {
        return this.inVertexId;
    }

    public static RelationIdentifier get(Object[] ids) {
        if (ids.length != 3 && ids.length != 4) {
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        for (int i = 0; i < 3; ++i) {
            if (!(ids[i] instanceof Number) || ((Number)ids[i]).longValue() >= 0L) continue;
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        return new RelationIdentifier(ids[1], ((Number)ids[2]).longValue(), ((Number)ids[0]).longValue(), ids.length == 4 ? ids[3] : Integer.valueOf(0));
    }

    public static RelationIdentifier get(int[] ids) {
        if (ids.length != 3 && ids.length != 4) {
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        for (int i = 0; i < 3; ++i) {
            if (ids[i] >= 0) continue;
            throw new IllegalArgumentException("Not a valid relation identifier: " + Arrays.toString(ids));
        }
        return new RelationIdentifier(ids[1], ids[2], ids[0], ids.length == 4 ? ids[3] : 0);
    }

    public int hashCode() {
        return Long.hashCode(this.relationId);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        RelationIdentifier oth = (RelationIdentifier)other;
        return this.relationId == oth.relationId && this.typeId == oth.typeId;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(LongEncoding.encode(this.relationId)).append(TOSTRING_DELIMITER).append(LongEncoding.encode(((Number)this.outVertexId).longValue())).append(TOSTRING_DELIMITER).append(LongEncoding.encode(this.typeId));
        if (this.inVertexId != null && ((Number)this.inVertexId).longValue() > 0L) {
            s.append(TOSTRING_DELIMITER).append(LongEncoding.encode(((Number)this.inVertexId).longValue()));
        }
        return s.toString();
    }

    public static RelationIdentifier parse(String id) {
        String[] elements = id.split(TOSTRING_DELIMITER);
        if (elements.length != 3 && elements.length != 4) {
            throw new IllegalArgumentException("Not a valid relation identifier: " + id);
        }
        try {
            return new RelationIdentifier(LongEncoding.decode(elements[1]), LongEncoding.decode(elements[2]), LongEncoding.decode(elements[0]), elements.length == 4 ? LongEncoding.decode(elements[3]) : 0L);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid id - each token expected to be a number", e);
        }
    }
}

