/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MetricsMaster;
import org.apache.hadoop.hbase.procedure.MasterProcedureManager;
import org.apache.hadoop.hbase.procedure.ProcedureManagerHost;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MasterProcedureManagerHost
extends ProcedureManagerHost<MasterProcedureManager> {
    private Hashtable<String, MasterProcedureManager> procedureMgrMap = new Hashtable();

    @Override
    public void loadProcedures(Configuration conf) {
        this.loadUserProcedures(conf, "hbase.procedure.master.classes");
        for (MasterProcedureManager mpm : this.getProcedureManagers()) {
            this.procedureMgrMap.put(mpm.getProcedureSignature(), mpm);
        }
    }

    public void initialize(MasterServices master, MetricsMaster metricsMaster) throws KeeperException, IOException, UnsupportedOperationException {
        for (MasterProcedureManager mpm : this.getProcedureManagers()) {
            mpm.initialize(master, metricsMaster);
        }
    }

    public void stop(String why) {
        for (MasterProcedureManager mpm : this.getProcedureManagers()) {
            mpm.stop(why);
        }
    }

    public MasterProcedureManager getProcedureManager(String signature) {
        return this.procedureMgrMap.get(signature);
    }
}

