/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.client.LogEntry;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.hadoop.hbase.util.GsonUtil;
import org.apache.hbase.thirdparty.com.google.gson.Gson;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class BalancerRejection
extends LogEntry {
    private final String reason;
    private final List<String> costFuncInfoList;
    private static final Gson GSON = GsonUtil.createGson().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter((Type)((Object)BalancerRejection.class), (balancerRejection, type, jsonSerializationContext) -> {
        Gson gson = new Gson();
        return gson.toJsonTree(balancerRejection);
    }).create();

    private BalancerRejection(String reason, List<String> costFuncInfoList) {
        this.reason = reason;
        this.costFuncInfoList = costFuncInfoList == null ? Collections.emptyList() : costFuncInfoList;
    }

    public String getReason() {
        return this.reason;
    }

    public List<String> getCostFuncInfoList() {
        return this.costFuncInfoList;
    }

    public String toString() {
        return new ToStringBuilder(this).append("reason", this.reason).append("costFuncInfoList", this.costFuncInfoList.toString()).toString();
    }

    @Override
    public String toJsonPrettyPrint() {
        return GSON.toJson(this);
    }

    public static class Builder {
        private String reason;
        private List<String> costFuncInfoList;

        public Builder setReason(String reason) {
            this.reason = reason;
            return this;
        }

        public void addCostFuncInfo(String funcName, double cost, float multiplier) {
            if (this.costFuncInfoList == null) {
                this.costFuncInfoList = new ArrayList<String>();
            }
            this.costFuncInfoList.add(funcName + " cost:" + cost + " multiplier:" + multiplier);
        }

        public Builder setCostFuncInfoList(List<String> costFuncInfoList) {
            this.costFuncInfoList = costFuncInfoList;
            return this;
        }

        public BalancerRejection build() {
            return new BalancerRejection(this.reason, this.costFuncInfoList);
        }
    }
}

