/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.client;

import org.apache.hadoop.hbase.shaded.org.apache.kerby.KOption;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.KOptionInfo;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.KOptionType;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.client.KrbOptionGroup;

public enum PkinitOption implements KOption
{
    NONE(null),
    USE_PKINIT(new KOptionInfo("use-pkinit", "using pkinit", KrbOptionGroup.PKINIT)),
    X509_IDENTITY(new KOptionInfo("x509-identities", "X509 user private key and cert", KrbOptionGroup.PKINIT, KOptionType.STR)),
    X509_PRIVATE_KEY(new KOptionInfo("x509-privatekey", "X509 user private key", KrbOptionGroup.PKINIT, KOptionType.STR)),
    X509_CERTIFICATE(new KOptionInfo("x509-cert", "X509 user certificate", KrbOptionGroup.PKINIT, KOptionType.STR)),
    X509_ANCHORS(new KOptionInfo("x509-anchors", "X509 anchors", KrbOptionGroup.PKINIT, KOptionType.STR)),
    USING_RSA(new KOptionInfo("using-rsa-or-dh", "Using RSA or DH", KrbOptionGroup.PKINIT)),
    USE_ANONYMOUS(new KOptionInfo("use-pkinit-anonymous", "X509 anonymous", KrbOptionGroup.PKINIT));

    private final KOptionInfo optionInfo;

    private PkinitOption(KOptionInfo optionInfo) {
        this.optionInfo = optionInfo;
    }

    @Override
    public KOptionInfo getOptionInfo() {
        return this.optionInfo;
    }

    public static PkinitOption fromOptionName(String optionName) {
        if (optionName != null) {
            for (PkinitOption ko : PkinitOption.values()) {
                if (ko.optionInfo == null || !ko.optionInfo.getName().equals(optionName)) continue;
                return ko;
            }
        }
        return NONE;
    }
}

