/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.client.KrbConfigKey;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.common.Krb5Conf;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionType;

public class KrbConfig
extends Krb5Conf {
    private static final String LIBDEFAULT = "libdefaults";
    private static final String REALMS = "realms";

    public boolean enableDebug() {
        return this.getBoolean(KrbConfigKey.KRB_DEBUG, true, LIBDEFAULT);
    }

    public String getKdcHost() {
        return this.getString(KrbConfigKey.KDC_HOST, true, LIBDEFAULT);
    }

    public int getKdcPort() {
        Integer kdcPort = this.getInt(KrbConfigKey.KDC_PORT, true, LIBDEFAULT);
        if (kdcPort != null) {
            return kdcPort;
        }
        return -1;
    }

    public int getKdcTcpPort() {
        Integer kdcPort = this.getInt(KrbConfigKey.KDC_TCP_PORT, true, LIBDEFAULT);
        if (kdcPort != null && kdcPort > 0) {
            return kdcPort;
        }
        return this.getKdcPort();
    }

    public boolean allowUdp() {
        return this.getBoolean(KrbConfigKey.KDC_ALLOW_UDP, true, LIBDEFAULT) != false || this.getInt(KrbConfigKey.KDC_UDP_PORT, true, LIBDEFAULT) != null || this.getInt(KrbConfigKey.KDC_PORT, false, LIBDEFAULT) != null;
    }

    public boolean allowTcp() {
        return this.getBoolean(KrbConfigKey.KDC_ALLOW_TCP, true, LIBDEFAULT) != false || this.getInt(KrbConfigKey.KDC_TCP_PORT, true, LIBDEFAULT) != null || this.getInt(KrbConfigKey.KDC_PORT, false, LIBDEFAULT) != null;
    }

    public int getKdcUdpPort() {
        Integer kdcPort = this.getInt(KrbConfigKey.KDC_UDP_PORT, true, LIBDEFAULT);
        if (kdcPort != null && kdcPort > 0) {
            return kdcPort;
        }
        return this.getKdcPort();
    }

    public String getKdcRealm() {
        String realm = this.getString(KrbConfigKey.KDC_REALM, false, LIBDEFAULT);
        if (realm == null && (realm = this.getString(KrbConfigKey.DEFAULT_REALM, false, LIBDEFAULT)) == null) {
            realm = (String)KrbConfigKey.KDC_REALM.getDefaultValue();
        }
        return realm;
    }

    public boolean isPreauthRequired() {
        return this.getBoolean(KrbConfigKey.PREAUTH_REQUIRED, true, LIBDEFAULT);
    }

    public String getTgsPrincipal() {
        return this.getString(KrbConfigKey.TGS_PRINCIPAL, true, LIBDEFAULT);
    }

    public long getAllowableClockSkew() {
        return this.getLong(KrbConfigKey.CLOCKSKEW, true, LIBDEFAULT);
    }

    public boolean isEmptyAddressesAllowed() {
        return this.getBoolean(KrbConfigKey.EMPTY_ADDRESSES_ALLOWED, true, LIBDEFAULT);
    }

    public boolean isForwardableAllowed() {
        return this.getBoolean(KrbConfigKey.FORWARDABLE, true, LIBDEFAULT);
    }

    public boolean isPostdatedAllowed() {
        return this.getBoolean(KrbConfigKey.POSTDATED_ALLOWED, true, LIBDEFAULT);
    }

    public boolean isProxiableAllowed() {
        return this.getBoolean(KrbConfigKey.PROXIABLE, true, LIBDEFAULT);
    }

    public boolean isRenewableAllowed() {
        return this.getBoolean(KrbConfigKey.RENEWABLE_ALLOWED, true, LIBDEFAULT);
    }

    public long getMaximumRenewableLifetime() {
        return this.getLong(KrbConfigKey.MAXIMUM_RENEWABLE_LIFETIME, true, LIBDEFAULT);
    }

    public long getMaximumTicketLifetime() {
        return this.getLong(KrbConfigKey.MAXIMUM_TICKET_LIFETIME, true, LIBDEFAULT);
    }

    public long getMinimumTicketLifetime() {
        return this.getLong(KrbConfigKey.MINIMUM_TICKET_LIFETIME, true, LIBDEFAULT);
    }

    public List<EncryptionType> getEncryptionTypes() {
        return this.getEncTypes(KrbConfigKey.PERMITTED_ENCTYPES, true, LIBDEFAULT);
    }

    public boolean isPaEncTimestampRequired() {
        return this.getBoolean(KrbConfigKey.PA_ENC_TIMESTAMP_REQUIRED, true, LIBDEFAULT);
    }

    public boolean isBodyChecksumVerified() {
        return this.getBoolean(KrbConfigKey.VERIFY_BODY_CHECKSUM, true, LIBDEFAULT);
    }

    public String getDefaultRealm() {
        return this.getString(KrbConfigKey.DEFAULT_REALM, true, LIBDEFAULT);
    }

    public boolean getDnsLookUpKdc() {
        return this.getBoolean(KrbConfigKey.DNS_LOOKUP_KDC, true, LIBDEFAULT);
    }

    public boolean getDnsLookUpRealm() {
        return this.getBoolean(KrbConfigKey.DNS_LOOKUP_REALM, true, LIBDEFAULT);
    }

    public boolean getAllowWeakCrypto() {
        return this.getBoolean(KrbConfigKey.ALLOW_WEAK_CRYPTO, true, LIBDEFAULT);
    }

    public long getTicketLifetime() {
        return this.getLong(KrbConfigKey.TICKET_LIFETIME, true, LIBDEFAULT);
    }

    public long getRenewLifetime() {
        return this.getLong(KrbConfigKey.RENEW_LIFETIME, true, LIBDEFAULT);
    }

    public List<EncryptionType> getDefaultTgsEnctypes() {
        return this.getEncTypes(KrbConfigKey.DEFAULT_TGS_ENCTYPES, true, LIBDEFAULT);
    }

    public List<EncryptionType> getDefaultTktEnctypes() {
        return this.getEncTypes(KrbConfigKey.DEFAULT_TKT_ENCTYPES, true, LIBDEFAULT);
    }

    public List<String> getPkinitAnchors() {
        return Arrays.asList(this.getStringArray(KrbConfigKey.PKINIT_ANCHORS, true, LIBDEFAULT));
    }

    public List<String> getPkinitIdentities() {
        return Arrays.asList(this.getStringArray(KrbConfigKey.PKINIT_IDENTITIES, true, LIBDEFAULT));
    }

    public String getPkinitKdcHostName() {
        return this.getString(KrbConfigKey.PKINIT_KDC_HOSTNAME, true, LIBDEFAULT);
    }

    public List<Object> getRealmSectionItems(String realm, String key) {
        Map<String, Object> map = this.getRealmSection(realm);
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> items = new ArrayList<Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!entry.getKey().equals(key)) continue;
            items.add(entry.getValue());
        }
        return items;
    }

    public Map<String, Object> getRealmSection(String realm) {
        Object realms = this.getSection(REALMS);
        if (realms != null) {
            Map map = (Map)realms;
            for (Map.Entry entry : map.entrySet()) {
                if (!((String)entry.getKey()).equals(realm)) continue;
                return (Map)entry.getValue();
            }
        }
        return Collections.emptyMap();
    }
}

