/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.tinkerpop.gremlin.driver.Channelizer;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.ser.Serializers;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;

public class ProfilingApplication {
    private static final Random random = new Random();
    private static final String[] scripts = new String[]{"g.V()", "g.V(1).out('knows')", "g.V(1).out('knows').has('name','josh')", "g.V(1).as(\"a\").out(\"knows\").as(\"b\").select(\"a\", \"b\")", "g.V(1).as(\"a\").out(\"knows\").as(\"b\").select(\"a\", \"b\").by(\"name\")", "g.V().hasLabel(\"person\").as(\"p\").map(__.bothE().label().groupCount()).as(\"r\").select(\"p\", \"r\")", "g.V().choose(__.outE().count().is(0L), __.as(\"a\"), __.as(\"b\")).choose(__.select(\"a\"), __.select(\"a\"), __.select(\"b\"))", "g.V().group(\"a\").by(T.label).by(outE().values(\"weight\").sum()).cap(\"a\")", "g.V().repeat(__.union(__.out(\"knows\").group(\"a\").by(\"age\"), __.out(\"created\").group(\"b\").by(\"name\").by(count())).group(\"a\").by(\"name\")).times(2).cap(\"a\", \"b\")", "g.V().match(\n  as(\"a\").out(\"knows\").as(\"b\"),\n  as(\"b\").out(\"created\").has(\"name\", \"lop\"),\n  as(\"b\").match(\n  as(\"b\").out(\"created\").as(\"d\"),\n  as(\"d\").in(\"created\").as(\"c\")).select(\"c\").as(\"c\")).<Vertex>select(\"a\", \"b\", \"c\")"};
    private final Cluster cluster;
    private final int requests;
    private final String executionName;
    private final String script;
    private final int tooSlowThreshold;
    private final boolean exercise;
    private final ExecutorService executor;

    public ProfilingApplication(String executionName, Cluster cluster, int requests, ExecutorService executor, String script, int tooSlowThreshold, boolean exercise) {
        this.executionName = executionName;
        this.cluster = cluster;
        this.requests = requests;
        this.executor = executor;
        this.script = script;
        this.tooSlowThreshold = tooSlowThreshold;
        this.exercise = exercise;
    }

    public long execute() throws Exception {
        AtomicInteger tooSlow = new AtomicInteger(0);
        String executionId = "[" + this.executionName + "]";
        try (Object client = this.cluster.connect();){
            CountDownLatch latch = new CountDownLatch(this.requests);
            ((Client)client).init();
            long start = System.nanoTime();
            IntStream.range(0, this.requests).forEach(i -> {
                String s = this.exercise ? this.chooseScript() : this.script;
                client.submitAsync(s).thenAcceptAsync(r -> {
                    try {
                        r.all().get(this.tooSlowThreshold, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException ex) {
                        tooSlow.incrementAndGet();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        latch.countDown();
                    }
                }, (Executor)this.executor);
            });
            latch.await();
            long end = System.nanoTime();
            long total = end - start;
            double totalSeconds = (double)total / 1.0E9;
            long requestCount = this.requests;
            long reqSec = Math.round((double)requestCount / totalSeconds);
            System.out.println(String.format(StringUtils.rightPad((String)executionId, (int)10) + " requests: %s | time(s): %s | req/sec: %s | too slow: %s", requestCount, StringUtils.rightPad((String)String.valueOf(totalSeconds), (int)14), StringUtils.rightPad((String)String.valueOf(reqSec), (int)7), this.exercise ? "N/A" : Integer.valueOf(tooSlow.get())));
            long l = reqSec;
            return l;
        }
    }

    private String chooseScript() {
        return scripts[random.nextInt(scripts.length - 1)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Map options = ElementHelper.asMap((Object[])args);
        boolean noExit = Boolean.parseBoolean(options.getOrDefault("noExit", "false").toString());
        int parallelism = Integer.parseInt(options.getOrDefault("parallelism", "16").toString());
        BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("profiler-%d").build();
        ExecutorService executor = Executors.newFixedThreadPool(parallelism, (ThreadFactory)threadFactory);
        String host = options.getOrDefault("host", "localhost").toString();
        int minExpectedRps = Integer.parseInt(options.getOrDefault("minExpectedRps", "1000").toString());
        int timeout = Integer.parseInt(options.getOrDefault("timeout", "1200000").toString());
        int warmups = Integer.parseInt(options.getOrDefault("warmups", "5").toString());
        int executions = Integer.parseInt(options.getOrDefault("executions", "10").toString());
        int nioPoolSize = Integer.parseInt(options.getOrDefault("nioPoolSize", "1").toString());
        int requests = Integer.parseInt(options.getOrDefault("requests", "10000").toString());
        int minConnectionPoolSize = Integer.parseInt(options.getOrDefault("minConnectionPoolSize", "256").toString());
        int maxConnectionPoolSize = Integer.parseInt(options.getOrDefault("maxConnectionPoolSize", "256").toString());
        int minSimultaneousUsagePerConnection = Integer.parseInt(options.getOrDefault("minSimultaneousUsagePerConnection", "8").toString());
        int maxSimultaneousUsagePerConnection = Integer.parseInt(options.getOrDefault("maxSimultaneousUsagePerConnection", "32").toString());
        int maxInProcessPerConnection = Integer.parseInt(options.getOrDefault("maxInProcessPerConnection", "64").toString());
        int minInProcessPerConnection = Integer.parseInt(options.getOrDefault("minInProcessPerConnection", "16").toString());
        int maxWaitForConnection = Integer.parseInt(options.getOrDefault("maxWaitForConnection", "3000").toString());
        int workerPoolSize = Integer.parseInt(options.getOrDefault("workerPoolSize", "2").toString());
        int tooSlowThreshold = Integer.parseInt(options.getOrDefault("tooSlowThreshold", "125").toString());
        String channelizer = options.getOrDefault("channelizer", Channelizer.WebSocketChannelizer.class.getName()).toString();
        String serializer = options.getOrDefault("serializer", Serializers.GRAPHBINARY_V1D0.name()).toString();
        boolean exercise = Boolean.parseBoolean(options.getOrDefault("exercise", "false").toString());
        String script = options.getOrDefault("script", "1+1").toString();
        Cluster cluster = Cluster.build(host).minConnectionPoolSize(minConnectionPoolSize).maxConnectionPoolSize(maxConnectionPoolSize).minSimultaneousUsagePerConnection(minSimultaneousUsagePerConnection).maxSimultaneousUsagePerConnection(maxSimultaneousUsagePerConnection).minInProcessPerConnection(minInProcessPerConnection).maxInProcessPerConnection(maxInProcessPerConnection).nioPoolSize(nioPoolSize).channelizer(channelizer).maxWaitForConnection(maxWaitForConnection).serializer(Serializers.valueOf(serializer)).workerPoolSize(workerPoolSize).create();
        try {
            Object fileName;
            File f;
            if (exercise) {
                System.out.println("--------------------------INITIALIZATION--------------------------");
                Object client = cluster.connect();
                ((Client)client).submit("graph.clear()").all().join();
                System.out.println("Cleared existing 'graph'");
                ((Client)client).submit("TinkerFactory.generateModern(graph)").all().join();
                ((Client)client).close();
                System.out.println("Modern graph loaded");
            }
            File file = f = null == (fileName = options.get("store")) ? null : new File(fileName.toString());
            if (f != null && f.length() == 0L) {
                try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(f, true)));){
                    writer.println("parallelism\tnioPoolSize\tminConnectionPoolSize\tmaxConnectionPoolSize\tminSimultaneousUsagePerConnection\tmaxSimultaneousUsagePerConnection\tminInProcessPerConnection\tmaxInProcessPerConnection\tworkerPoolSize\trequestPerSecond");
                }
            }
            AtomicBoolean meetsRpsExpectation = new AtomicBoolean(true);
            System.out.println("---------------------------WARMUP CYCLE---------------------------");
            for (int ix = 0; ix < warmups && meetsRpsExpectation.get(); ++ix) {
                long averageRequestsPerSecond = new ProfilingApplication("warmup-" + (ix + 1), cluster, 1000, executor, script, tooSlowThreshold, exercise).execute();
                meetsRpsExpectation.set(averageRequestsPerSecond > (long)minExpectedRps);
                TimeUnit.SECONDS.sleep(1L);
            }
            AtomicBoolean exceededTimeout = new AtomicBoolean(false);
            long totalRequestsPerSecond = 0L;
            if (exercise || meetsRpsExpectation.get()) {
                long start = System.nanoTime();
                System.out.println("----------------------------TEST CYCLE----------------------------");
                for (int ix = 0; ix < executions && !exceededTimeout.get(); ++ix) {
                    totalRequestsPerSecond += new ProfilingApplication("test-" + (ix + 1), cluster, requests, executor, script, tooSlowThreshold, exercise).execute();
                    exceededTimeout.set(System.nanoTime() - start > TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS));
                    TimeUnit.SECONDS.sleep(1L);
                }
            }
            int averageRequestPerSecond = !meetsRpsExpectation.get() || exceededTimeout.get() ? 0 : Math.round(totalRequestsPerSecond / (long)executions);
            System.out.println(String.format("avg req/sec: %s", averageRequestPerSecond));
            if (f != null) {
                try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(f, true)));){
                    writer.println(String.join((CharSequence)"\t", String.valueOf(parallelism), String.valueOf(nioPoolSize), String.valueOf(minConnectionPoolSize), String.valueOf(maxConnectionPoolSize), String.valueOf(minSimultaneousUsagePerConnection), String.valueOf(maxSimultaneousUsagePerConnection), String.valueOf(minInProcessPerConnection), String.valueOf(maxInProcessPerConnection), String.valueOf(workerPoolSize), String.valueOf(averageRequestPerSecond)));
                }
            }
            if (!noExit) {
                System.exit(0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (!noExit) {
                System.exit(1);
            }
        }
        finally {
            executor.shutdown();
            cluster.close();
        }
    }
}

