/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.VMOperationInfo;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.jdk.SplittableRandomAccessors;
import com.oracle.svm.core.thread.NativeVMOperationData;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.IsolateThread;

public abstract class JavaVMOperation
extends VMOperation
implements VMOperationControl.JavaAllocationFreeQueue.Element<JavaVMOperation> {
    protected IsolateThread queuingThread;
    private JavaVMOperation next;
    private volatile boolean finished;

    protected JavaVMOperation(VMOperationInfo info) {
        super(info);
        SplittableRandomAccessors.getDefaultGen();
        VMError.guarantee(!SubstrateUtil.HOSTED, "must not be created at image build time");
    }

    @Override
    public JavaVMOperation getNext() {
        return this.next;
    }

    @Override
    public void setNext(JavaVMOperation value) {
        this.next = value;
    }

    public void enqueue() {
        VMOperationControl.get().enqueue(this);
    }

    @Override
    protected IsolateThread getQueuingThread(NativeVMOperationData data) {
        return this.queuingThread;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void setQueuingThread(NativeVMOperationData data, IsolateThread thread) {
        this.queuingThread = thread;
    }

    @Override
    protected boolean isFinished(NativeVMOperationData data) {
        return this.finished;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void setFinished(NativeVMOperationData data, boolean value) {
        this.finished = value;
    }

    @Override
    protected final boolean hasWork(NativeVMOperationData data) {
        return this.hasWork();
    }

    protected boolean hasWork() {
        return true;
    }

    @Deprecated(forRemoval=true)
    public static void enqueueBlockingSafepoint(String name, SubstrateUtil.Thunk thunk) {
        ThunkOperation vmOperation = new ThunkOperation(thunk);
        vmOperation.enqueue();
    }

    @Override
    public final void operate(NativeVMOperationData data) {
        this.operate();
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, reason="Whitelisted because some operations may allocate.")
    protected abstract void operate();

    @Deprecated(forRemoval=true)
    private static class ThunkOperation
    extends JavaVMOperation {
        private SubstrateUtil.Thunk thunk;

        ThunkOperation(SubstrateUtil.Thunk thunk) {
            super(VMOperationInfos.get(ThunkOperation.class, "Unnamed VM operation", VMOperation.SystemEffect.SAFEPOINT));
            this.thunk = thunk;
        }

        @Override
        public void operate() {
            this.thunk.invoke();
        }
    }
}

