/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.sampler.SamplerBuffer;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

final class SamplerBufferAccess {
    private SamplerBufferAccess() {
    }

    @Fold
    public static UnsignedWord getHeaderSize() {
        return UnsignedUtils.roundUp(SizeOf.unsigned(SamplerBuffer.class), WordFactory.unsigned((int)ConfigurationValues.getTarget().wordSize));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static SamplerBuffer allocate(UnsignedWord dataSize) {
        UnsignedWord headerSize = SamplerBufferAccess.getHeaderSize();
        SamplerBuffer result = (SamplerBuffer)((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).malloc(headerSize.add(dataSize));
        if (result.isNonNull()) {
            result.setSize(dataSize);
            result.setFreeable(false);
            SamplerBufferAccess.reinitialize(result);
        }
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void free(SamplerBuffer buffer) {
        ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)buffer);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void reinitialize(SamplerBuffer buffer) {
        Pointer dataStart = SamplerBufferAccess.getDataStart(buffer);
        buffer.setPos(dataStart);
        buffer.setOwner(0L);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getDataStart(SamplerBuffer buffer) {
        return ((Pointer)buffer).add(SamplerBufferAccess.getHeaderSize());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isEmpty(SamplerBuffer buffer) {
        return SamplerBufferAccess.getDataStart(buffer).equal((UnsignedWord)buffer.getPos());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getDataEnd(SamplerBuffer buffer) {
        return SamplerBufferAccess.getDataStart(buffer).add(buffer.getSize());
    }
}

