/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.jdk.LoadAverageSupport;
import com.oracle.svm.core.posix.headers.Stdlib;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.c.type.CDoublePointer;

@AutomaticallyRegisteredImageSingleton(value={LoadAverageSupport.class})
class PosixLoadAverageSupport
implements LoadAverageSupport {
    PosixLoadAverageSupport() {
    }

    @Override
    public int getLoadAverage(double[] loadavg, int nelems) {
        try (PinnedObject pinnedLoadavg = PinnedObject.create((Object)loadavg);){
            int n = Stdlib.getloadavg((CDoublePointer)pinnedLoadavg.addressOfArrayElement(0), nelems);
            return n;
        }
    }
}

