/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;

final class IgnoreSIGPIPEStartupHook
implements RuntimeSupport.Hook {
    private static final CEntryPointLiteral<Signal.SignalDispatcher> NOOP_SIGNAL_HANDLER = CEntryPointLiteral.create(IgnoreSIGPIPEStartupHook.class, (String)"noopSignalHandler", (Class[])new Class[]{Integer.TYPE});

    IgnoreSIGPIPEStartupHook() {
    }

    @CEntryPoint(publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    @Uninterruptible(reason="empty signal handler, Isolate is not set up")
    static void noopSignalHandler(int sig) {
    }

    @Override
    public void execute(boolean isFirstIsolate) {
        if (isFirstIsolate) {
            Signal.SignalDispatcher signalResult = PosixUtils.installSignalHandler(Signal.SignalEnum.SIGPIPE.getCValue(), (Signal.SignalDispatcher)NOOP_SIGNAL_HANDLER.getFunctionPointer());
            VMError.guarantee(signalResult != Signal.SIG_ERR(), "IgnoreSIGPIPEFeature.run: Could not ignore SIGPIPE");
        }
    }
}

