/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.option.OptionOrigin;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.util.VMError;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;

final class MacroOptionOrigin
extends OptionOrigin {
    public final OptionUtils.MacroOptionKind kind;
    public final String name;
    public final Path optionDirectory;

    private MacroOptionOrigin(OptionUtils.MacroOptionKind kind, String name, URI optionDirectory) {
        this.kind = kind;
        this.name = name;
        VMError.guarantee(optionDirectory != null, "Invalid optionDirectory origin");
        this.optionDirectory = Path.of(optionDirectory);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.name});
    }

    public boolean equals(Object obj) {
        if (obj instanceof MacroOptionOrigin) {
            MacroOptionOrigin that = (MacroOptionOrigin)obj;
            return Objects.equals((Object)this.kind, (Object)that.kind) && Objects.equals(this.name, that.name);
        }
        return false;
    }

    public static MacroOptionOrigin from(String rawOrigin) {
        for (OptionUtils.MacroOptionKind kind : OptionUtils.MacroOptionKind.values()) {
            String prefix = kind.getDescriptionPrefix(true);
            if (!rawOrigin.startsWith(prefix)) continue;
            int optionDirectorySep = rawOrigin.indexOf(64);
            VMError.guarantee(optionDirectorySep > 0, "Missing macro-option optionDirectory origin");
            String optionDirectory = rawOrigin.substring(optionDirectorySep + 1);
            int argumentOriginSep = optionDirectory.indexOf(64);
            if (argumentOriginSep > 0) {
                optionDirectory = optionDirectory.substring(0, argumentOriginSep);
            }
            return new MacroOptionOrigin(kind, rawOrigin.substring(prefix.length()), MacroOptionOrigin.originURI(optionDirectory));
        }
        return null;
    }

    @Override
    public boolean commandLineLike() {
        return OptionUtils.MacroOptionKind.Macro.equals((Object)this.kind);
    }

    public String toString() {
        return this.kind + " option '" + this.name + "'";
    }

    @Override
    public List<String> getRedirectionValues(Path valuesFile) throws IOException {
        Path normalizedRedirPath = this.optionDirectory.resolve(valuesFile).normalize();
        return MacroOptionOrigin.getRedirectionValuesFromPath(normalizedRedirPath);
    }
}

