/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni;

import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.jni.JNIObjectHandles;
import com.oracle.svm.core.jni.JNIThreadLocalEnvironment;
import com.oracle.svm.core.jni.JNIThreadLocalPendingException;
import com.oracle.svm.core.jni.JNIThreadLocalPinnedObjects;
import com.oracle.svm.core.jni.access.JNIAccessibleField;
import com.oracle.svm.core.jni.access.JNINativeLinkage;
import com.oracle.svm.core.jni.headers.JNIEnvironment;
import com.oracle.svm.core.jni.headers.JNIFieldId;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import java.lang.reflect.Array;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class JNIGeneratedMethodSupport {
    static PointerBase nativeCallAddress(JNINativeLinkage linkage) {
        return linkage.getOrFindEntryPoint();
    }

    static int nativeCallPrologue() {
        return JNIObjectHandles.pushLocalFrame(16);
    }

    static void nativeCallEpilogue(int handleFrame) {
        JNIObjectHandles.popLocalFramesIncluding(handleFrame);
    }

    static JNIEnvironment environment() {
        return JNIThreadLocalEnvironment.getAddress();
    }

    @Uninterruptible(reason="Allow inlining from entry points, which are uninterruptible.", mayBeInlined=true)
    static JNIObjectHandle boxObjectInLocalHandle(Object obj) {
        return JNIObjectHandles.createLocal(obj);
    }

    @Uninterruptible(reason="Allow inlining from entry points, which are uninterruptible.", mayBeInlined=true)
    static Object unboxHandle(JNIObjectHandle handle) {
        return JNIObjectHandles.getObject(handle);
    }

    @Uninterruptible(reason="Allow inlining from field accessor methods, which are uninterruptible.", mayBeInlined=true)
    static WordBase getFieldOffsetFromId(JNIFieldId fieldId) {
        return JNIAccessibleField.getOffsetFromId(fieldId);
    }

    @Uninterruptible(reason="Allow inlining from field accessor methods, which are uninterruptible.", mayBeInlined=true)
    static Object getStaticPrimitiveFieldsArray() {
        return StaticFieldsSupport.getStaticPrimitiveFields();
    }

    @Uninterruptible(reason="Allow inlining from field accessor methods, which are uninterruptible.", mayBeInlined=true)
    static Object getStaticObjectFieldsArray() {
        return StaticFieldsSupport.getStaticObjectFields();
    }

    static void setPendingException(Throwable t) {
        JNIThreadLocalPendingException.set(t);
    }

    static Throwable getAndClearPendingException() {
        Throwable t = JNIThreadLocalPendingException.get();
        JNIThreadLocalPendingException.clear();
        return t;
    }

    static void rethrowPendingException() throws Throwable {
        Throwable t = JNIGeneratedMethodSupport.getAndClearPendingException();
        if (t != null) {
            throw t;
        }
    }

    static PointerBase pinArrayAndGetAddress(Object array, CCharPointer isCopy) throws Throwable {
        if (array.getClass().isArray()) {
            if (isCopy.isNonNull()) {
                isCopy.write((byte)0);
            }
            return JNIThreadLocalPinnedObjects.pinArrayAndGetAddress(array);
        }
        return WordFactory.nullPointer();
    }

    static boolean unpinArrayByAddress(PointerBase address) throws Throwable {
        return JNIThreadLocalPinnedObjects.unpinArrayByAddress(address);
    }

    static void getPrimitiveArrayRegion(JavaKind elementKind, Object array, int start, int count, PointerBase buffer) {
        if (start < 0 || count < 0 || start + count > Array.getLength(array)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (count > 0) {
            long offset = ConfigurationValues.getObjectLayout().getArrayElementOffset(elementKind, start);
            int elementSize = ConfigurationValues.getObjectLayout().sizeInBytes(elementKind);
            Unsafe.getUnsafe().copyMemory(array, offset, null, buffer.rawValue(), count * elementSize);
        }
    }

    static void setPrimitiveArrayRegion(JavaKind elementKind, Object array, int start, int count, PointerBase buffer) {
        if (start < 0 || count < 0 || start + count > Array.getLength(array)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (count > 0) {
            long offset = ConfigurationValues.getObjectLayout().getArrayElementOffset(elementKind, start);
            int elementSize = ConfigurationValues.getObjectLayout().sizeInBytes(elementKind);
            Unsafe.getUnsafe().copyMemory(null, buffer.rawValue(), array, offset, count * elementSize);
        }
    }
}

