/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public enum JfrThreadState {
    NEW("STATE_NEW"),
    RUNNABLE("STATE_RUNNABLE"),
    BLOCKED("STATE_BLOCKED"),
    WAITING("STATE_WAITING"),
    TIMED_WAITING("STATE_TIMED_WAITING"),
    TERMINATED("STATE_TERMINATED");

    private final String text;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private JfrThreadState(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getId() {
        return this.ordinal();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getId(Thread.State threadState) {
        return JfrThreadState.threadStateToJfrThreadState(threadState).getId();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static JfrThreadState threadStateToJfrThreadState(Thread.State threadState) {
        switch (threadState) {
            case NEW: {
                return NEW;
            }
            case RUNNABLE: {
                return RUNNABLE;
            }
            case BLOCKED: {
                return BLOCKED;
            }
            case WAITING: {
                return WAITING;
            }
            case TIMED_WAITING: {
                return TIMED_WAITING;
            }
            case TERMINATED: {
                return TERMINATED;
            }
        }
        throw VMError.shouldNotReachHere("Unknown thread state!");
    }
}

