/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk17;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JDK17OrLater;
import com.oracle.svm.core.jdk.ModuleUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@TargetClass(value=Module.class, onlyWith={JDK17OrLater.class})
public final class Target_java_lang_Module_JDK17OrLater {
    @Substitute
    private static void defineModule0(Module module, boolean isOpen, String version, String location, Object[] pns) {
        if (Arrays.stream(pns).anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("Bad package name");
        }
        List<String> packages = Arrays.stream(pns).map(Object::toString).collect(Collectors.toUnmodifiableList());
        ModuleUtil.defineModule(module, isOpen, packages);
    }
}

