/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.management;

import com.oracle.svm.core.JavaMainWrapper;
import com.oracle.svm.core.jdk.RuntimeSupport;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.ProcessProperties;
import sun.management.Util;

final class SubstrateRuntimeMXBean
implements RuntimeMXBean {
    private final String managementSpecVersion = ManagementFactory.getRuntimeMXBean().getManagementSpecVersion();
    private long startMillis;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    SubstrateRuntimeMXBean() {
        RuntimeSupport.getRuntimeSupport().addInitializationHook(isFirstIsolate -> this.initialize());
    }

    void initialize() {
        this.startMillis = System.currentTimeMillis();
    }

    @Override
    public List<String> getInputArguments() {
        if (ImageSingletons.contains(JavaMainWrapper.JavaMainSupport.class)) {
            return ((JavaMainWrapper.JavaMainSupport)ImageSingletons.lookup(JavaMainWrapper.JavaMainSupport.class)).getInputArguments();
        }
        return Collections.emptyList();
    }

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName("java.lang:type=Runtime");
    }

    @Override
    public String getName() {
        String hostName;
        long id;
        try {
            id = ProcessProperties.getProcessID();
        }
        catch (Throwable t) {
            id = GraalServices.getGlobalTimeStamp();
        }
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostName = "localhost";
        }
        return id + "@" + hostName;
    }

    @Override
    public String getVmName() {
        return System.getProperty("java.vm.name");
    }

    @Override
    public String getVmVendor() {
        return System.getProperty("java.vm.vendor");
    }

    @Override
    public String getVmVersion() {
        return System.getProperty("java.vm.version");
    }

    @Override
    public String getSpecName() {
        return System.getProperty("java.vm.specification.name");
    }

    @Override
    public String getSpecVendor() {
        return System.getProperty("java.vm.specification.vendor");
    }

    @Override
    public String getSpecVersion() {
        return System.getProperty("java.vm.specification.version");
    }

    @Override
    public String getManagementSpecVersion() {
        return this.managementSpecVersion;
    }

    @Override
    public String getClassPath() {
        return System.getProperty("java.class.path");
    }

    @Override
    public String getLibraryPath() {
        return System.getProperty("java.vm.library.path");
    }

    @Override
    public boolean isBootClassPathSupported() {
        return false;
    }

    @Override
    public String getBootClassPath() {
        throw new UnsupportedOperationException("boot class path mechanism is not supported");
    }

    @Override
    public long getUptime() {
        return System.currentTimeMillis() - this.startMillis;
    }

    @Override
    public long getStartTime() {
        assert (this.startMillis > 0L) : "SubstrateRuntimeMXBean.getStartTime: Should have set SubstrateRuntimeMXBean.startMillis.";
        return this.startMillis;
    }

    @Override
    public Map<String, String> getSystemProperties() {
        Properties sysProps = System.getProperties();
        HashMap<String, String> map = new HashMap<String, String>();
        Set<String> keys = sysProps.stringPropertyNames();
        for (String k : keys) {
            String value = sysProps.getProperty(k);
            map.put(k, value);
        }
        return map;
    }
}

