/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.UnreachableBeginNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.extended.ForeignCall;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.compiler.nodes.util.GraphUtil;

@NodeInfo(nameTemplate="ForeignCallWithException#{p#descriptor/s}", allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_2, cyclesRationale="Rough estimation of the call operation itself.", size=NodeSize.SIZE_2, sizeRationale="Rough estimation of the call operation itself.")
@Node.NodeIntrinsicFactory
public class ForeignCallWithExceptionNode
extends WithExceptionNode
implements ForeignCall,
Simplifiable {
    public static final NodeClass<ForeignCallWithExceptionNode> TYPE = NodeClass.create(ForeignCallWithExceptionNode.class);
    @Node.Input
    protected NodeInputList<ValueNode> arguments;
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateDuring;
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateAfter;
    protected final ForeignCallDescriptor descriptor;
    protected int bci = -5;

    public static boolean intrinsify(GraphBuilderContext b, @Node.InjectedNodeParameter Stamp returnStamp, ForeignCallDescriptor descriptor, ValueNode ... arguments) {
        return ForeignCallNode.finishIntrinsification((GraphBuilderContext)b, (Stamp)returnStamp, (ForeignCall)new ForeignCallWithExceptionNode(descriptor, arguments));
    }

    public ForeignCallWithExceptionNode(ForeignCallDescriptor descriptor, ValueNode ... arguments) {
        this(TYPE, descriptor, arguments);
    }

    protected ForeignCallWithExceptionNode(NodeClass<? extends ForeignCallWithExceptionNode> c, ForeignCallDescriptor descriptor, ValueNode ... arguments) {
        super(c, StampFactory.forKind((JavaKind)JavaKind.fromJavaClass((Class)descriptor.getResultType())));
        this.arguments = new NodeInputList((Node)this, (Node[])arguments);
        this.descriptor = descriptor;
        assert (descriptor.getArgumentTypes().length == this.arguments.size()) : "wrong number of arguments to " + this;
    }

    public boolean hasSideEffect() {
        return !this.descriptor.isReexecutable();
    }

    public ForeignCallDescriptor getDescriptor() {
        return this.descriptor;
    }

    public FrameState stateAfter() {
        return this.stateAfter;
    }

    public void setStateAfter(FrameState stateAfter) {
        assert (this.hasSideEffect() || stateAfter == null);
        this.updateUsages((Node)this.stateAfter(), (Node)stateAfter);
        this.stateAfter = stateAfter;
    }

    public FrameState stateDuring() {
        return this.stateDuring;
    }

    public void setStateDuring(FrameState stateDuring) {
        this.updateUsages((Node)this.stateDuring, (Node)stateDuring);
        this.stateDuring = stateDuring;
    }

    public int bci() {
        return this.bci;
    }

    public void setBci(int bci) {
        assert (this.bci == -5 || this.bci == bci);
        this.bci = bci;
    }

    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Name) {
            return super.toString(verbosity) + "#" + this.descriptor;
        }
        return super.toString(verbosity);
    }

    public NodeInputList<ValueNode> getArguments() {
        return this.arguments;
    }

    public void simplify(SimplifierTool tool) {
        if (this.exceptionEdge instanceof UnreachableBeginNode) {
            FixedNode replacement = this.replaceWithNonThrowing();
            tool.addToWorkList((Node)replacement);
        }
    }

    public FixedNode replaceWithNonThrowing() {
        ForeignCallNode foreignCall = (ForeignCallNode)this.asNode().graph().add((Node)new ForeignCallNode(this.descriptor, this.stamp, this.arguments));
        foreignCall.setStateAfter(this.stateAfter());
        foreignCall.setStateDuring(this.stateDuring());
        AbstractBeginNode nextBegin = this.next;
        AbstractBeginNode oldException = this.exceptionEdge;
        this.graph().replaceSplitWithFixed((ControlSplitNode)this, (FixedWithNextNode)foreignCall, nextBegin);
        GraphUtil.killCFG((FixedNode)oldException);
        return foreignCall;
    }
}

