/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.aarch64;

import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import jdk.vm.ci.code.Register;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AArch64SafepointCheckOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64SafepointCheckOp> TYPE = LIRInstructionClass.create(AArch64SafepointCheckOp.class);

    public AArch64SafepointCheckOp() {
        super(TYPE);
    }

    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        assert (SubstrateOptions.MultiThreaded.getValue().booleanValue());
        int safepointSize = 32;
        AArch64Address safepointAddress = AArch64Address.createImmediateAddress((int)safepointSize, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, (Register)ReservedRegisters.singleton().getThreadRegister(), (int)Safepoint.getThreadLocalSafepointRequestedOffset());
        try (AArch64MacroAssembler.ScratchRegister scratchRegister = masm.getScratchRegister();){
            Register scratch = scratchRegister.getRegister();
            masm.ldr(safepointSize, scratch, safepointAddress);
            if (ThreadingSupportImpl.isRecurringCallbackSupported()) {
                masm.subs(safepointSize, scratch, scratch, 1);
                masm.str(safepointSize, scratch, safepointAddress);
            } else {
                masm.compare(safepointSize, scratch, 0);
            }
        }
    }

    public AArch64Assembler.ConditionFlag getConditionFlag() {
        return AArch64Assembler.ConditionFlag.LE;
    }
}

