/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.UseSerialOrEpsilonGC;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.thread.VMOperation;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.impl.PinnedObjectSupport;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

final class PinnedObjectImpl
implements PinnedObject {
    private final Object referent;
    private volatile boolean open = true;
    private PinnedObjectImpl next;

    static void pushPinnedObject(PinnedObjectImpl newHead) {
        PinnedObjectImpl sampleHead;
        HeapImpl heap = HeapImpl.getHeapImpl();
        UninterruptibleUtils.AtomicReference<PinnedObjectImpl> pinHead = heap.getPinHead();
        do {
            newHead.next = sampleHead = pinHead.get();
        } while (!pinHead.compareAndSet(sampleHead, newHead));
    }

    static PinnedObjectImpl getPinnedObjects() {
        assert (VMOperation.isGCInProgress());
        UninterruptibleUtils.AtomicReference<PinnedObjectImpl> pinHead = HeapImpl.getHeapImpl().getPinHead();
        return pinHead.get();
    }

    static void setPinnedObjects(PinnedObjectImpl list) {
        assert (VMOperation.isGCInProgress());
        UninterruptibleUtils.AtomicReference<PinnedObjectImpl> pinHead = HeapImpl.getHeapImpl().getPinHead();
        pinHead.set(list);
    }

    PinnedObjectImpl(Object object) {
        this.referent = object;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void close() {
        assert (this.open) : "Should not call close() on a closed PinnedObject.";
        this.open = false;
    }

    public Object getObject() {
        assert (this.open) : "Should not call getObject() on a closed PinnedObject.";
        return this.referent;
    }

    public Pointer addressOfObject() {
        assert (this.open) : "Should not call addressOfObject() on a closed PinnedObject.";
        return Word.objectToUntrackedPointer((Object)this.referent);
    }

    public <T extends PointerBase> T addressOfArrayElement(int index) {
        if (this.referent == null) {
            throw new NullPointerException("null PinnedObject");
        }
        DynamicHub hub = ObjectHeader.readDynamicHubFromObject(this.referent);
        UnsignedWord offsetOfArrayElement = LayoutEncoding.getArrayElementOffset(hub.getLayoutEncoding(), index);
        return (T)this.addressOfObject().add(offsetOfArrayElement);
    }

    public boolean isOpen() {
        return this.open;
    }

    public PinnedObjectImpl getNext() {
        return this.next;
    }

    void setNext(PinnedObjectImpl value) {
        if (value != this.next) {
            this.next = value;
        }
    }

    @AutomaticallyRegisteredImageSingleton(value={PinnedObjectSupport.class}, onlyWith={UseSerialOrEpsilonGC.class})
    static class PinnedObjectSupportImpl
    implements PinnedObjectSupport {
        PinnedObjectSupportImpl() {
        }

        public PinnedObject create(Object object) {
            PinnedObjectImpl result = new PinnedObjectImpl(object);
            PinnedObjectImpl.pushPinnedObject(result);
            return result;
        }

        public boolean isPinned(Object object) {
            PinnedObjectImpl pin = HeapImpl.getHeapImpl().getPinHead().get();
            while (pin != null) {
                if (pin.open && pin.referent == object) {
                    return true;
                }
                pin = pin.next;
            }
            return false;
        }
    }
}

