/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.executor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Locale;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.executor.ProcfsMetrics;
import org.apache.spark.executor.ProcfsMetricsGetter$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub!B\u000e\u001d\u0001y!\u0003\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\t\u000by\u0002A\u0011A \t\u000f\r\u0003!\u0019!C\u0005\t\"1A\n\u0001Q\u0001\n\u0015Cq!\u0014\u0001C\u0002\u0013%a\n\u0003\u0004S\u0001\u0001\u0006Ia\u0014\u0005\b'\u0002\u0011\r\u0011\"\u0003U\u0011\u0019A\u0006\u0001)A\u0005+\"9\u0011\f\u0001a\u0001\n\u0013q\u0005b\u0002.\u0001\u0001\u0004%Ia\u0017\u0005\u0007C\u0002\u0001\u000b\u0015B(\t\u000f\t\u0004!\u0019!C\u0005G\"1q\r\u0001Q\u0001\n\u0011D\u0001\u0002\u001b\u0001\t\u0006\u0004%IA\u0014\u0005\u0006S\u0002!IA\u001b\u0005\u0006W\u0002!I\u0001\u001c\u0005\u0006[\u0002!IA\u001c\u0005\u0006e\u0002!Ia\u001d\u0005\u0006{\u0002!\tA \u0005\t\u0003\u0017\u0001A\u0011\u0001\u0010\u0002\u000e\u001dA\u0011q\u0002\u000f\t\u0002y\t\tBB\u0004\u001c9!\u0005a$a\u0005\t\ry2B\u0011AA\u000b\u0011%\t9B\u0006b\u0001\n\u000b\tI\u0002C\u0004\u0002\u001cY\u0001\u000bQ\u0002!\t\u0013\u0005ua#%A\u0005\u0002\u0005}!a\u0005)s_\u000e47/T3ue&\u001c7oR3ui\u0016\u0014(BA\u000f\u001f\u0003!)\u00070Z2vi>\u0014(BA\u0010!\u0003\u0015\u0019\b/\u0019:l\u0015\t\t#%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002G\u0005\u0019qN]4\u0014\u0007\u0001)3\u0006\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VM\u001a\t\u0003Y=j\u0011!\f\u0006\u0003]y\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003a5\u0012q\u0001T8hO&tw-A\u0005qe>\u001cgm\u001d#je\u000e\u0001\u0001C\u0001\u001b<\u001d\t)\u0014\b\u0005\u00027O5\tqG\u0003\u00029e\u00051AH]8pizJ!AO\u0014\u0002\rA\u0013X\rZ3g\u0013\taTH\u0001\u0004TiJLgn\u001a\u0006\u0003u\u001d\na\u0001P5oSRtDC\u0001!C!\t\t\u0005!D\u0001\u001d\u0011\u001d\t$\u0001%AA\u0002M\na\u0002\u001d:pG\u001a\u001c8\u000b^1u\r&dW-F\u0001F!\t15*D\u0001H\u0015\tA\u0015*\u0001\u0003mC:<'\"\u0001&\u0002\t)\fg/Y\u0005\u0003y\u001d\u000bq\u0002\u001d:pG\u001a\u001c8\u000b^1u\r&dW\rI\u0001\bi\u0016\u001cH/\u001b8h+\u0005y\u0005C\u0001\u0014Q\u0013\t\tvEA\u0004C_>dW-\u00198\u0002\u0011Q,7\u000f^5oO\u0002\n\u0001\u0002]1hKNK'0Z\u000b\u0002+B\u0011aEV\u0005\u0003/\u001e\u0012A\u0001T8oO\u0006I\u0001/Y4f'&TX\rI\u0001\fSN\fe/Y5mC\ndW-A\bjg\u00063\u0018-\u001b7bE2,w\fJ3r)\tav\f\u0005\u0002';&\u0011al\n\u0002\u0005+:LG\u000fC\u0004a\u0015\u0005\u0005\t\u0019A(\u0002\u0007a$\u0013'\u0001\u0007jg\u00063\u0018-\u001b7bE2,\u0007%A\u0002qS\u0012,\u0012\u0001\u001a\t\u0003M\u0015L!AZ\u0014\u0003\u0007%sG/\u0001\u0003qS\u0012\u0004\u0013!E5t!J|7MZ:Bm\u0006LG.\u00192mK\u0006Q1m\\7qkR,\u0007+\u001b3\u0015\u0003\u0011\fqbY8naV$X\rU1hKNK'0\u001a\u000b\u0002+\u0006\u00112m\\7qkR,\u0007K]8dKN\u001cHK]3f)\u0005y\u0007c\u0001\u001bqI&\u0011\u0011/\u0010\u0002\u0004'\u0016$\u0018\u0001D4fi\u000eC\u0017\u000e\u001c3QS\u0012\u001cHC\u0001;}!\r)(\u0010Z\u0007\u0002m*\u0011q\u000f_\u0001\b[V$\u0018M\u00197f\u0015\tIx%\u0001\u0006d_2dWm\u0019;j_:L!a\u001f<\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\u0005\u0006EJ\u0001\r\u0001Z\u0001\u001fC\u0012$\u0007K]8dMNlU\r\u001e:jGN4%o\\7P]\u0016\u0004&o\\2fgN$Ra`A\u0003\u0003\u0013\u00012!QA\u0001\u0013\r\t\u0019\u0001\b\u0002\u000e!J|7MZ:NKR\u0014\u0018nY:\t\r\u0005\u001d1\u00031\u0001\u0000\u0003)\tG\u000e\\'fiJL7m\u001d\u0005\u0006EN\u0001\r\u0001Z\u0001\u0012G>l\u0007/\u001e;f\u00032dW*\u001a;sS\u000e\u001cH#A@\u0002'A\u0013xn\u00194t\u001b\u0016$(/[2t\u000f\u0016$H/\u001a:\u0011\u0005\u000532C\u0001\f&)\t\t\t\"A\u0005q)J,W-\u00138g_V\t\u0001)\u0001\u0006q)J,W-\u00138g_\u0002\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nTCAA\u0011U\r\u0019\u00141E\u0016\u0003\u0003K\u0001B!a\n\u000225\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\ti#A\u0005v]\u000eDWmY6fI*\u0019\u0011qF\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00024\u0005%\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class ProcfsMetricsGetter
implements Logging {
    private boolean isProcfsAvailable;
    private final String procfsDir;
    private final String procfsStatFile;
    private final boolean testing;
    private final long pageSize;
    private boolean isAvailable;
    private final int pid;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$1() {
        return ProcfsMetricsGetter$.MODULE$.$lessinit$greater$default$1();
    }

    public static ProcfsMetricsGetter pTreeInfo() {
        return ProcfsMetricsGetter$.MODULE$.pTreeInfo();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String procfsStatFile() {
        return this.procfsStatFile;
    }

    private boolean testing() {
        return this.testing;
    }

    private long pageSize() {
        return this.pageSize;
    }

    private boolean isAvailable() {
        return this.isAvailable;
    }

    private void isAvailable_$eq(boolean x$1) {
        this.isAvailable = x$1;
    }

    private int pid() {
        return this.pid;
    }

    private boolean isProcfsAvailable$lzycompute() {
        ProcfsMetricsGetter procfsMetricsGetter = this;
        synchronized (procfsMetricsGetter) {
            if (!this.bitmap$0) {
                boolean bl;
                if (this.testing()) {
                    bl = true;
                } else {
                    Try procDirExists = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.exists(Paths.get($this.procfsDir, new String[0]), new LinkOption[0])).recover((PartialFunction)new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ProcfsMetricsGetter $outer;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            if (A1 instanceof IOException) {
                                IOException iOException = (IOException)A1;
                                this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception checking for procfs dir", iOException);
                                object = BoxesRunTime.boxToBoolean((boolean)false);
                            } else {
                                object = function1.apply(x1);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            Throwable throwable = x1;
                            boolean bl = throwable instanceof IOException;
                            return bl;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1()}, serializedLambda);
                        }
                    });
                    boolean shouldPollProcessTreeMetrics = BoxesRunTime.unboxToBoolean((Object)SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.EXECUTOR_PROCESS_TREE_METRICS_ENABLED()));
                    bl = BoxesRunTime.unboxToBoolean((Object)procDirExists.get()) && shouldPollProcessTreeMetrics;
                }
                this.isProcfsAvailable = bl;
                this.bitmap$0 = true;
            }
        }
        return this.isProcfsAvailable;
    }

    private boolean isProcfsAvailable() {
        return !this.bitmap$0 ? this.isProcfsAvailable$lzycompute() : this.isProcfsAvailable;
    }

    private int computePid() {
        int n;
        if (!this.isAvailable() || this.testing()) {
            return -1;
        }
        try {
            String[] cmd = (String[])((Object[])new String[]{"bash", "-c", "echo $PPID"});
            String out = Utils$.MODULE$.executeAndGetOutput((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])cmd), Utils$.MODULE$.executeAndGetOutput$default$2(), Utils$.MODULE$.executeAndGetOutput$default$3(), Utils$.MODULE$.executeAndGetOutput$default$4());
            n = Integer.parseInt(out.split("\n")[0]);
        }
        catch (SparkException e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception when trying to compute process tree. As a result reporting of ProcessTree metrics is stopped", e);
            this.isAvailable_$eq(false);
            n = -1;
        }
        return n;
    }

    private long computePageSize() {
        long l;
        if (this.testing()) {
            return 4096L;
        }
        try {
            String[] cmd = (String[])((Object[])new String[]{"getconf", "PAGESIZE"});
            String out = Utils$.MODULE$.executeAndGetOutput((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])cmd), Utils$.MODULE$.executeAndGetOutput$default$2(), Utils$.MODULE$.executeAndGetOutput$default$3(), Utils$.MODULE$.executeAndGetOutput$default$4());
            l = Integer.parseInt(out.split("\n")[0]);
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception when trying to compute pagesize, as a result reporting of ProcessTree metrics is stopped");
            this.isAvailable_$eq(false);
            l = 0L;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    private Set<Object> computeProcessTree() {
        void var1_1;
        if (!this.isAvailable() || this.testing()) {
            return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        }
        Set ptree = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        ptree = (Set)ptree.$plus((Object)BoxesRunTime.boxToInteger((int)this.pid()));
        Queue queue = (Queue)Queue$.MODULE$.empty();
        queue.$plus$eq((Object)BoxesRunTime.boxToInteger((int)this.pid()));
        while (!queue.isEmpty()) {
            int p = BoxesRunTime.unboxToInt((Object)queue.dequeue());
            ArrayBuffer<Object> c = this.getChildPids(p);
            if (c.isEmpty()) continue;
            queue.$plus$plus$eq(c);
            ptree = (Set)ptree.$plus$plus((GenTraversableOnce)c.toSet());
        }
        return var1_1;
    }

    private ArrayBuffer<Object> getChildPids(int pid) {
        ArrayBuffer arrayBuffer;
        try {
            ProcessBuilder builder = new ProcessBuilder("pgrep", "-P", ((Object)BoxesRunTime.boxToInteger((int)pid)).toString());
            Process process = builder.start();
            ArrayBuffer childPidsInInt = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            Thread stdoutThread = Utils$.MODULE$.processStreamByLine("read stdout for pgrep", process.getInputStream(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)s -> {
                this.appendChildPid$1(s, childPidsInInt);
                return BoxedUnit.UNIT;
            });
            StringBuilder errorStringBuilder = new StringBuilder();
            Thread stdErrThread = Utils$.MODULE$.processStreamByLine("stderr for pgrep", process.getErrorStream(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)line -> {
                errorStringBuilder.append(line);
                return BoxedUnit.UNIT;
            });
            int exitCode = process.waitFor();
            stdoutThread.join();
            stdErrThread.join();
            String errorString = errorStringBuilder.toString();
            if (exitCode != 0 && exitCode > 2) {
                String cmd = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(builder.command().toArray())).mkString(" ");
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(39).append("Process ").append(cmd).append(" exited with code ").append(exitCode).append(" and stderr: ").append(errorString).toString());
                throw new SparkException(new java.lang.StringBuilder(26).append("Process ").append(cmd).append(" exited with code ").append(exitCode).toString());
            }
            arrayBuffer = childPidsInInt;
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception when trying to compute process tree. As a result reporting of ProcessTree metrics is stopped.", e);
            this.isAvailable_$eq(false);
            arrayBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        }
        return arrayBuffer;
    }

    public ProcfsMetrics addProcfsMetricsFromOneProcess(ProcfsMetrics allMetrics, int pid) {
        ProcfsMetrics procfsMetrics;
        try {
            File pidDir = new File(this.procfsDir, ((Object)BoxesRunTime.boxToInteger((int)pid)).toString());
            procfsMetrics = (ProcfsMetrics)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> this.openReader$1(pid), (Function1 & Serializable & scala.Serializable)in -> {
                ProcfsMetrics procfsMetrics;
                String procInfo = in.readLine();
                String[] procInfoSplit = procInfo.split(" ");
                long vmem = new StringOps(Predef$.MODULE$.augmentString(procInfoSplit[22])).toLong();
                long rssMem = new StringOps(Predef$.MODULE$.augmentString(procInfoSplit[23])).toLong() * this.pageSize();
                if (procInfoSplit[1].toLowerCase(Locale.US).contains("java")) {
                    procfsMetrics = allMetrics.copy(allMetrics.jvmVmemTotal() + vmem, allMetrics.jvmRSSTotal() + rssMem, allMetrics.copy$default$3(), allMetrics.copy$default$4(), allMetrics.copy$default$5(), allMetrics.copy$default$6());
                } else if (procInfoSplit[1].toLowerCase(Locale.US).contains("python")) {
                    long x$1 = allMetrics.pythonVmemTotal() + vmem;
                    long x$2 = allMetrics.pythonRSSTotal() + rssMem;
                    long x$3 = allMetrics.copy$default$1();
                    long x$4 = allMetrics.copy$default$2();
                    long x$5 = allMetrics.copy$default$5();
                    long x$6 = allMetrics.copy$default$6();
                    procfsMetrics = allMetrics.copy(x$3, x$4, x$1, x$2, x$5, x$6);
                } else {
                    long x$7 = allMetrics.otherVmemTotal() + vmem;
                    long x$8 = allMetrics.otherRSSTotal() + rssMem;
                    long x$9 = allMetrics.copy$default$1();
                    long x$10 = allMetrics.copy$default$2();
                    long x$11 = allMetrics.copy$default$3();
                    long x$12 = allMetrics.copy$default$4();
                    procfsMetrics = allMetrics.copy(x$9, x$10, x$11, x$12, x$7, x$8);
                }
                return procfsMetrics;
            });
        }
        catch (IOException f) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "There was a problem with reading the stat file of the process. ", f);
            procfsMetrics = new ProcfsMetrics(0L, 0L, 0L, 0L, 0L, 0L);
        }
        return procfsMetrics;
    }

    public ProcfsMetrics computeAllMetrics() {
        ProcfsMetrics procfsMetrics;
        Object object = new Object();
        try {
            if (!this.isAvailable()) {
                return new ProcfsMetrics(0L, 0L, 0L, 0L, 0L, 0L);
            }
            Set<Object> pids = this.computeProcessTree();
            ObjectRef allMetrics = ObjectRef.create((Object)new ProcfsMetrics(0L, 0L, 0L, 0L, 0L, 0L));
            pids.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)p -> {
                allMetrics$2.elem = this.addProcfsMetricsFromOneProcess((ProcfsMetrics)allMetrics$2.elem, p);
                if (!this.isAvailable()) {
                    throw new NonLocalReturnControl(object, (Object)new ProcfsMetrics(0L, 0L, 0L, 0L, 0L, 0L));
                }
            });
            procfsMetrics = (ProcfsMetrics)allMetrics.elem;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                procfsMetrics = (ProcfsMetrics)ex.value();
            }
            throw ex;
        }
        return procfsMetrics;
    }

    private final void appendChildPid$1(String s, ArrayBuffer childPidsInInt$1) {
        block0: {
            String string = s;
            String string2 = "";
            if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(18).append("Found a child pid:").append(s).toString());
            childPidsInInt$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)Integer.parseInt(s)));
        }
    }

    private final BufferedReader openReader$1(int pid$1) {
        File f = new File(new File(this.procfsDir, ((Object)BoxesRunTime.boxToInteger((int)pid$1)).toString()), this.procfsStatFile());
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8));
    }

    public ProcfsMetricsGetter(String procfsDir) {
        this.procfsDir = procfsDir;
        Logging.$init$(this);
        this.procfsStatFile = "stat";
        this.testing = Utils$.MODULE$.isTesting();
        this.pageSize = this.computePageSize();
        this.isAvailable = this.isProcfsAvailable();
        this.pid = this.computePid();
    }
}

