/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal.jni;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.graalvm.jniutils.HotSpotCalls;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIExceptionWrapper;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.libgraal.jni.annotation.FromLibGraalId;
import org.graalvm.nativeimage.c.type.CTypeConversion;

public abstract class FromLibGraalCalls<T extends Enum<T>> {
    private static final Map<String, JNIClass> classes = new ConcurrentHashMap<String, JNIClass>();
    private final EnumMap<T, JNIMethodImpl<T>> methods;
    private final HotSpotCalls hotSpotCalls;
    private volatile JNI.JClass peer;

    protected FromLibGraalCalls(Class<T> idType) {
        this.methods = new EnumMap(idType);
        this.hotSpotCalls = HotSpotCalls.getDefault();
    }

    protected abstract JNI.JClass resolvePeer(JNI.JNIEnv var1);

    public final void callVoid(JNI.JNIEnv env, T id, JNI.JValue args) {
        JNIMethodImpl<T> method = this.getJNIMethod(env, id, Void.TYPE);
        this.hotSpotCalls.callStaticVoid(env, this.peer(env), method, args);
    }

    public final boolean callBoolean(JNI.JNIEnv env, T id, JNI.JValue args) {
        JNIMethodImpl<T> method = this.getJNIMethod(env, id, Boolean.TYPE);
        return this.hotSpotCalls.callStaticBoolean(env, this.peer(env), method, args);
    }

    public final long callLong(JNI.JNIEnv env, T id, JNI.JValue args) {
        JNIMethodImpl<T> method = this.getJNIMethod(env, id, Long.TYPE);
        return this.hotSpotCalls.callStaticLong(env, this.peer(env), method, args);
    }

    public final int callInt(JNI.JNIEnv env, T id, JNI.JValue args) {
        JNIMethodImpl<T> method = this.getJNIMethod(env, id, Integer.TYPE);
        return this.hotSpotCalls.callStaticInt(env, this.peer(env), method, args);
    }

    public final <R extends JNI.JObject> R callJObject(JNI.JNIEnv env, T id, JNI.JValue args) {
        JNIMethodImpl<T> method = this.getJNIMethod(env, id, Object.class);
        return this.hotSpotCalls.callStaticJObject(env, this.peer(env), method, args);
    }

    public static JNI.JClass getJNIClass(JNI.JNIEnv env, Class<?> clazz) {
        if (clazz.isArray()) {
            throw new UnsupportedOperationException("Array classes are not supported");
        }
        return FromLibGraalCalls.getJNIClassImpl((JNI.JNIEnv)env, (String)clazz.getName()).jclass;
    }

    public static JNI.JClass getJNIClass(JNI.JNIEnv env, String className) {
        return FromLibGraalCalls.getJNIClassImpl((JNI.JNIEnv)env, (String)className).jclass;
    }

    private static JNIClass getJNIClassImpl(final JNI.JNIEnv env, String className) {
        try {
            return classes.computeIfAbsent(className, new Function<String, JNIClass>(){

                @Override
                public JNIClass apply(String name) {
                    JNI.JClass clazz;
                    JNI.JObject classLoader = JNIUtil.getJVMCIClassLoader(env);
                    JNI.JClass jClass = clazz = classLoader.isNull() ? JNIUtil.findClass(env, JNIUtil.getBinaryName(name)) : JNIUtil.findClass(env, classLoader, JNIUtil.getBinaryName(name));
                    if (clazz.isNull()) {
                        JNIUtil.ExceptionClear(env);
                        throw new InternalError("Cannot load class: " + name);
                    }
                    return new JNIClass(name, JNIUtil.NewGlobalRef(env, clazz, "Class<" + name + ">"));
                }
            });
        }
        catch (InternalError ie) {
            JNIExceptionWrapper.wrapAndThrowPendingJNIException(env);
            throw ie;
        }
    }

    private JNIMethodImpl<T> getJNIMethod(final JNI.JNIEnv env, T hcId, Class<?> expectedReturnType) {
        assert (((FromLibGraalId)hcId).getReturnType() == expectedReturnType || expectedReturnType.isAssignableFrom(((FromLibGraalId)hcId).getReturnType()));
        try {
            return (JNIMethodImpl)this.methods.computeIfAbsent(hcId, new Function<T, JNIMethodImpl<T>>(){

                @Override
                public JNIMethodImpl<T> apply(T id) {
                    JNI.JClass c = FromLibGraalCalls.this.peer(env);
                    String methodName = ((FromLibGraalId)id).getMethodName();
                    try (CTypeConversion.CCharPointerHolder name = CTypeConversion.toCString((CharSequence)methodName);){
                        JNIMethodImpl jNIMethodImpl;
                        block13: {
                            CTypeConversion.CCharPointerHolder sig = CTypeConversion.toCString((CharSequence)((FromLibGraalId)id).getSignature());
                            try {
                                JNI.JMethodID jniId = JNIUtil.GetStaticMethodID(env, c, name.get(), sig.get());
                                if (jniId.isNull()) {
                                    throw new InternalError("No such method: " + methodName);
                                }
                                jNIMethodImpl = new JNIMethodImpl(id, jniId);
                                if (sig == null) break block13;
                            }
                            catch (Throwable throwable) {
                                if (sig != null) {
                                    try {
                                        sig.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            sig.close();
                        }
                        return jNIMethodImpl;
                    }
                }
            });
        }
        catch (InternalError ie) {
            JNIExceptionWrapper.wrapAndThrowPendingJNIException(env);
            throw ie;
        }
    }

    private JNI.JClass peer(JNI.JNIEnv env) {
        if (this.peer.isNull()) {
            this.peer = this.resolvePeer(env);
        }
        return this.peer;
    }

    static final class JNIMethodImpl<T extends Enum<T>>
    implements HotSpotCalls.JNIMethod {
        final T hcId;
        final JNI.JMethodID jniId;

        JNIMethodImpl(T hcId, JNI.JMethodID jniId) {
            this.hcId = hcId;
            this.jniId = jniId;
        }

        @Override
        public JNI.JMethodID getJMethodID() {
            return this.jniId;
        }

        @Override
        public String getDisplayName() {
            return ((FromLibGraalId)this.hcId).getName();
        }

        public String toString() {
            return this.hcId + "[0x" + Long.toHexString(this.jniId.rawValue()) + "]";
        }
    }

    static final class JNIClass {
        final String className;
        final JNI.JClass jclass;

        JNIClass(String className, JNI.JClass clazz) {
            this.className = className;
            this.jclass = clazz;
        }
    }
}

