/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.jniutils;

import java.util.Objects;
import org.graalvm.jniutils.HSObject;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIUtil;

public class JNIMethodScope
implements AutoCloseable {
    private static final ThreadLocal<JNIMethodScope> topScope = new ThreadLocal();
    private final JNI.JNIEnv env;
    private final JNIMethodScope parent;
    private JNIMethodScope leaf;
    HSObject locals;
    private final String scopeName;
    private JNI.JObject objResult;

    public static JNI.JNIEnv env() {
        return JNIMethodScope.scope().env;
    }

    public JNI.JNIEnv getEnv() {
        return this.env;
    }

    public static JNIMethodScope scopeOrNull() {
        JNIMethodScope scope = topScope.get();
        if (scope == null) {
            return null;
        }
        return scope.leaf;
    }

    public static JNIMethodScope scope() {
        JNIMethodScope scope = topScope.get();
        if (scope == null) {
            throw new IllegalStateException("Not in the scope of an JNI method call");
        }
        return scope.leaf;
    }

    public JNIMethodScope(String scopeName, JNI.JNIEnv env) {
        Objects.requireNonNull(scopeName, "ScopeName must be non null.");
        this.scopeName = scopeName;
        JNIMethodScope top = topScope.get();
        this.env = env;
        if (top == null) {
            top = this;
            this.parent = null;
            topScope.set(this);
        } else {
            if (top.env != this.env) {
                throw new IllegalStateException("Cannot mix JNI scopes: " + this + " and " + top);
            }
            this.parent = top.leaf;
        }
        top.leaf = this;
        JNIUtil.trace(1, "HS->%s[enter]: %s", JNIUtil.getFeatureName(), scopeName);
    }

    public void setObjectResult(JNI.JObject obj) {
        this.objResult = obj;
    }

    public <R extends JNI.JObject> R getObjectResult() {
        return (R)this.objResult;
    }

    @Override
    public void close() {
        JNIUtil.trace(1, "HS->%s[ exit]: %s", JNIUtil.getFeatureName(), this.scopeName);
        HSObject.invalidate(this.locals);
        if (this.parent == null) {
            if (topScope.get() != this) {
                throw new IllegalStateException("Unexpected JNI scope: " + topScope.get());
            }
            topScope.set(null);
        } else {
            JNIMethodScope top = this.parent;
            while (top.parent != null) {
                top = top.parent;
            }
            top.leaf = this.parent;
        }
    }

    int depth() {
        int depth = 0;
        JNIMethodScope ancestor = this.parent;
        while (ancestor != null) {
            ++depth;
            ancestor = ancestor.parent;
        }
        return depth;
    }

    public String toString() {
        return "JNIMethodScope[" + this.depth() + "]@" + Long.toHexString(this.env.rawValue());
    }
}

