/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.nodes.RootNode;
import jdk.vm.ci.code.stack.InspectedFrame;
import org.graalvm.compiler.truffle.runtime.CompilationState;
import org.graalvm.compiler.truffle.runtime.GraalFrameInstance;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedOSRLoopNode;

public final class GraalOSRFrameInstance
extends GraalFrameInstance {
    private final InspectedFrame osrFrame;

    GraalOSRFrameInstance(InspectedFrame callTargetFrame, InspectedFrame callNodeFrame, InspectedFrame osrFrame) {
        super(callTargetFrame, callNodeFrame);
        this.osrFrame = osrFrame;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Frame getFrame(FrameInstance.FrameAccess access) {
        Frame materializedOSRFrame = this.getFrameFrom(this.osrFrame, access);
        if (this.getOSRRootNode() instanceof OptimizedOSRLoopNode.LoopOSRRootNode) {
            return (Frame)materializedOSRFrame.getArguments()[0];
        }
        return materializedOSRFrame;
    }

    private RootNode getOSRRootNode() {
        return ((OptimizedCallTarget)this.osrFrame.getLocal(0)).getRootNode();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isVirtualFrame() {
        return this.osrFrame.isVirtual(1);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getCompilationTier() {
        return ((CompilationState)((Object)this.osrFrame.getLocal(2))).getTier();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isCompilationRoot() {
        return ((CompilationState)((Object)this.osrFrame.getLocal(2))).isCompilationRoot();
    }
}

