/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.truffle.compiler.PartialEvaluatorConfiguration;
import org.graalvm.compiler.truffle.compiler.TruffleStringConstantFieldProvider;
import org.graalvm.compiler.truffle.compiler.phases.TruffleCompilerPhases;
import org.graalvm.compiler.truffle.compiler.substitutions.KnownTruffleTypes;

public final class TruffleTierConfiguration {
    private final PartialEvaluatorConfiguration configuration;
    private final Backend backend;
    private final Providers providers;
    private final Suites suites;
    private final LIRSuites lirSuites;

    public TruffleTierConfiguration(PartialEvaluatorConfiguration configuration, Backend backend, OptionValues options, KnownTruffleTypes knownTruffleTypes) {
        this(configuration, backend, backend.getProviders(), backend.getSuites().getDefaultSuites(options, backend.getTarget().arch), backend.getSuites().getDefaultLIRSuites(options), knownTruffleTypes);
    }

    public TruffleTierConfiguration(PartialEvaluatorConfiguration configuration, Backend backend, Providers providers, Suites suites, LIRSuites lirSuites, KnownTruffleTypes knownTruffleTypes) {
        this.configuration = configuration;
        this.backend = backend;
        this.providers = providers.copyWith(new TruffleStringConstantFieldProvider(providers.getConstantFieldProvider(), providers.getMetaAccess(), knownTruffleTypes));
        this.suites = suites;
        this.lirSuites = lirSuites;
        TruffleCompilerPhases.register(providers, suites);
        this.suites.setImmutable();
    }

    public PartialEvaluatorConfiguration partialEvaluator() {
        return this.configuration;
    }

    public Backend backend() {
        return this.backend;
    }

    public Providers providers() {
        return this.providers;
    }

    public Suites suites() {
        return this.suites;
    }

    public LIRSuites lirSuites() {
        return this.lirSuites;
    }
}

