/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import org.graalvm.compiler.loop.phases.ConvertDeoptimizeToGuardPhase;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.ConditionalEliminationPhase;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.TruffleTierContext;
import org.graalvm.compiler.truffle.compiler.phases.FrameAccessVerificationPhase;
import org.graalvm.compiler.truffle.compiler.phases.PhiTransformPhase;
import org.graalvm.compiler.virtual.phases.ea.PartialEscapePhase;

public class PostPartialEvaluationSuite
extends PhaseSuite<TruffleTierContext> {
    public PostPartialEvaluationSuite(boolean iterativePartialEscape) {
        CanonicalizerPhase canonicalizerPhase = CanonicalizerPhase.create();
        this.appendPhase(new ConvertDeoptimizeToGuardPhase(canonicalizerPhase));
        this.appendPhase(new InlineReplacementsPhase());
        this.appendPhase(new ConditionalEliminationPhase(false));
        this.appendPhase(canonicalizerPhase);
        this.appendPhase(new FrameAccessVerificationPhase());
        this.appendPhase(new PartialEscapePhase(iterativePartialEscape, canonicalizerPhase, TruffleCompilerRuntime.getRuntime().getGraalOptions(OptionValues.class)));
        this.appendPhase(new PhiTransformPhase(canonicalizerPhase));
    }

    public static class InlineReplacementsPhase
    extends BasePhase<TruffleTierContext> {
        @Override
        protected void run(StructuredGraph graph, TruffleTierContext context) {
            for (MethodCallTargetNode methodCallTargetNode : graph.getNodes(MethodCallTargetNode.TYPE)) {
                StructuredGraph inlineGraph;
                if (!methodCallTargetNode.invokeKind().isDirect() || (inlineGraph = context.getProviders().getReplacements().getInlineSubstitution(methodCallTargetNode.targetMethod(), methodCallTargetNode.invoke().bci(), methodCallTargetNode.invoke().getInlineControl(), graph.trackNodeSourcePosition(), methodCallTargetNode.asNode().getNodeSourcePosition(), graph.allowAssumptions(), context.debug.getOptions())) == null) continue;
                InliningUtil.inline(methodCallTargetNode.invoke(), inlineGraph, true, methodCallTargetNode.targetMethod());
            }
        }
    }
}

