/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes.arithmetic;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.NegateNode;
import org.graalvm.compiler.nodes.extended.GuardedNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerExactArithmeticNode;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class IntegerNegExactNode
extends NegateNode
implements GuardedNode,
IntegerExactArithmeticNode,
IterableNodeType {
    public static final NodeClass<IntegerNegExactNode> TYPE = NodeClass.create(IntegerNegExactNode.class);
    @Node.Input(value=InputType.Guard)
    protected GuardingNode guard;

    public IntegerNegExactNode(ValueNode value, GuardingNode guard) {
        super(TYPE, value);
        this.setStamp(value.stamp(NodeView.DEFAULT).unrestricted());
        this.guard = guard;
    }

    @Override
    public boolean inferStamp() {
        return false;
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        IntegerStamp integerStamp = (IntegerStamp)newStamp;
        if (IntegerStamp.negateCanOverflow(integerStamp)) {
            return integerStamp.unrestricted();
        }
        return super.foldStamp(newStamp);
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        if (forValue.isConstant()) {
            JavaConstant cst = forValue.asJavaConstant();
            try {
                if (cst.getJavaKind() == JavaKind.Int) {
                    return ConstantNode.forInt(Math.negateExact(cst.asInt()));
                }
                assert (cst.getJavaKind() == JavaKind.Long);
                return ConstantNode.forLong(Math.negateExact(cst.asLong()));
            }
            catch (ArithmeticException arithmeticException) {
                return this;
            }
        }
        if (!IntegerStamp.negateCanOverflow((IntegerStamp)forValue.stamp(NodeView.DEFAULT))) {
            return (ValueNode)new NegateNode(forValue).canonical(tool);
        }
        return this;
    }

    @Override
    public GuardingNode getGuard() {
        return this.guard;
    }

    @Override
    public void setGuard(GuardingNode guard) {
        this.updateUsagesInterface(this.guard, guard);
        this.guard = guard;
    }
}

