/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.core.common.StrideUtil;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.replacements.nodes.ArrayEqualsNode;
import org.graalvm.compiler.replacements.nodes.ArrayRegionEqualsNode;
import org.graalvm.compiler.replacements.nodes.ForeignCalls;
import org.graalvm.word.Pointer;

public final class ArrayEqualsForeignCalls {
    private static final ForeignCallDescriptor STUB_LONG_ARRAY_EQUALS = ArrayEqualsForeignCalls.foreignCallDescriptorPointers("longArraysEquals");
    private static final ForeignCallDescriptor STUB_FLOAT_ARRAY_EQUALS = ArrayEqualsForeignCalls.foreignCallDescriptorPointers("floatArraysEquals");
    private static final ForeignCallDescriptor STUB_DOUBLE_ARRAY_EQUALS = ArrayEqualsForeignCalls.foreignCallDescriptorPointers("doubleArraysEquals");
    private static final ForeignCallDescriptor STUB_REGION_EQUALS_DYNAMIC_STRIDES = ForeignCalls.pureFunctionForeignCallDescriptor("arrayRegionEqualsDynamicStrides", Boolean.TYPE, Object.class, Long.TYPE, Object.class, Long.TYPE, Integer.TYPE, Integer.TYPE);
    public static final ForeignCallDescriptor[] STUBS = new ForeignCallDescriptor[]{ArrayEqualsForeignCalls.foreignCallDescriptor("arrayRegionEqualsS1S1"), ArrayEqualsForeignCalls.foreignCallDescriptor("arrayRegionEqualsS1S2"), ArrayEqualsForeignCalls.foreignCallDescriptor("arrayRegionEqualsS1S4"), ArrayEqualsForeignCalls.foreignCallDescriptor("arrayRegionEqualsS2S1"), ArrayEqualsForeignCalls.foreignCallDescriptor("arrayRegionEqualsS2S2"), ArrayEqualsForeignCalls.foreignCallDescriptor("arrayRegionEqualsS2S4"), ArrayEqualsForeignCalls.foreignCallDescriptor("arrayRegionEqualsS4S1"), ArrayEqualsForeignCalls.foreignCallDescriptor("arrayRegionEqualsS4S2"), ArrayEqualsForeignCalls.foreignCallDescriptor("arrayRegionEqualsS4S4"), STUB_REGION_EQUALS_DYNAMIC_STRIDES, STUB_LONG_ARRAY_EQUALS, STUB_FLOAT_ARRAY_EQUALS, STUB_DOUBLE_ARRAY_EQUALS};

    private static ForeignCallDescriptor foreignCallDescriptor(String name) {
        return ForeignCalls.pureFunctionForeignCallDescriptor(name, Boolean.TYPE, Object.class, Long.TYPE, Object.class, Long.TYPE, Integer.TYPE);
    }

    private static ForeignCallDescriptor foreignCallDescriptorPointers(String name) {
        return ForeignCalls.pureFunctionForeignCallDescriptor(name, Boolean.TYPE, Pointer.class, Long.TYPE, Pointer.class, Long.TYPE, Integer.TYPE);
    }

    public static ForeignCallDescriptor getArrayEqualsStub(ArrayEqualsNode arrayEqualsNode) {
        JavaKind kind = arrayEqualsNode.getKind();
        switch (kind) {
            case Boolean: 
            case Byte: 
            case Char: 
            case Short: 
            case Int: {
                return STUBS[StrideUtil.getDirectStubCallIndex(Stride.fromJavaKind((JavaKind)kind).log2, Stride.fromJavaKind((JavaKind)kind).log2)];
            }
            case Long: {
                return STUB_LONG_ARRAY_EQUALS;
            }
            case Float: {
                return STUB_FLOAT_ARRAY_EQUALS;
            }
            case Double: {
                return STUB_DOUBLE_ARRAY_EQUALS;
            }
        }
        return null;
    }

    public static ForeignCallDescriptor getRegionEqualsStub(ArrayRegionEqualsNode regionEqualsNode) {
        int directStubCallIndex = regionEqualsNode.getDirectStubCallIndex();
        GraalError.guarantee(-1 <= directStubCallIndex && directStubCallIndex < 9, "invalid direct stub call index");
        return directStubCallIndex < 0 ? STUB_REGION_EQUALS_DYNAMIC_STRIDES : STUBS[directStubCallIndex];
    }
}

