/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import java.util.BitSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.api.replacements.SnippetTemplateCache;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecode;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.TimerKey;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.loop.phases.ConvertDeoptimizeToGuardPhase;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.Cancellable;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.spi.SnippetParameterInfo;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.DeadCodeEliminationPhase;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.ConstantBindingParameterPlugin;
import org.graalvm.compiler.replacements.IntrinsicGraphBuilder;
import org.graalvm.compiler.replacements.NonNullParameterPlugin;
import org.graalvm.compiler.replacements.SnippetCounterNode;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyForeignCalls;
import org.graalvm.compiler.word.Word;
import org.graalvm.compiler.word.WordOperationPlugin;
import org.graalvm.compiler.word.WordTypes;

public class ReplacementsImpl
implements Replacements,
InlineInvokePlugin {
    protected Providers providers;
    public final SnippetReflectionProvider snippetReflection;
    public final TargetDescription target;
    private GraphBuilderConfiguration.Plugins graphBuilderPlugins;
    private final DebugHandlersFactory debugHandlersFactory;
    protected final ConcurrentMap<ResolvedJavaMethod, StructuredGraph> graphs;
    protected final BytecodeProvider defaultBytecodeProvider;
    private static final int MAX_GRAPH_INLINING_DEPTH = 100;
    private final EconomicMap<String, SnippetTemplateCache> snippetTemplateCache;
    private static final TimerKey SnippetPreparationTime = DebugContext.timer("SnippetPreparationTime");
    private static final AtomicInteger nextDebugContextId = new AtomicInteger();

    @Override
    public Providers getProviders() {
        return this.providers;
    }

    public void setProviders(Providers providers) {
        this.providers = providers.copyWith(this);
    }

    public void setGraphBuilderPlugins(GraphBuilderConfiguration.Plugins plugins) {
        assert (this.graphBuilderPlugins == null);
        this.graphBuilderPlugins = plugins;
    }

    @Override
    public GraphBuilderConfiguration.Plugins getGraphBuilderPlugins() {
        return this.graphBuilderPlugins;
    }

    @Override
    public <T> T getInjectedArgument(Class<T> capability) {
        if (capability.equals(TargetDescription.class)) {
            return (T)this.target;
        }
        if (capability.equals(ForeignCallsProvider.class)) {
            return (T)this.getProviders().getForeignCalls();
        }
        if (capability.equals(ArrayCopyForeignCalls.class) && this.getProviders().getForeignCalls() instanceof ArrayCopyForeignCalls) {
            return (T)this.getProviders().getForeignCalls();
        }
        if (capability.equals(SnippetReflectionProvider.class)) {
            return (T)this.snippetReflection;
        }
        if (capability.isAssignableFrom(WordTypes.class)) {
            return (T)this.getProviders().getWordTypes();
        }
        throw GraalError.shouldNotReachHere(capability.toString());
    }

    @Override
    public Stamp getInjectedStamp(Class<?> type, boolean nonNull) {
        JavaKind kind = JavaKind.fromJavaClass(type);
        if (kind == JavaKind.Object) {
            WordTypes wordTypes = this.getProviders().getWordTypes();
            if (wordTypes.isWord(type)) {
                return wordTypes.getWordStamp(type);
            }
            ResolvedJavaType returnType = this.providers.getMetaAccess().lookupJavaType(type);
            return StampFactory.object(TypeReference.createWithoutAssumptions(returnType), nonNull);
        }
        return StampFactory.forKind(kind);
    }

    @Override
    public Class<? extends GraphBuilderPlugin> getIntrinsifyingPlugin(ResolvedJavaMethod method) {
        if (!Services.IS_IN_NATIVE_IMAGE) {
            if (method.getAnnotation(Node.NodeIntrinsic.class) != null || method.getAnnotation(Fold.class) != null) {
                return GeneratedInvocationPlugin.class;
            }
            if (method.getAnnotation(Word.Operation.class) != null) {
                return WordOperationPlugin.class;
            }
        }
        return null;
    }

    @Override
    public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
        if (b.parsingIntrinsic()) {
            assert (b.getDepth() < 100) : "inlining limit exceeded";
            return InlineInvokePlugin.InlineInfo.createIntrinsicInlineInfo(method, this.defaultBytecodeProvider);
        }
        assert (Services.IS_BUILDING_NATIVE_IMAGE || method.getAnnotation(Node.NodeIntrinsic.class) == null) : String.format("@%s method %s must only be called from within a replacement%n%s", Node.NodeIntrinsic.class.getSimpleName(), method.format("%h.%n"), b);
        return null;
    }

    @Override
    public void notifyNotInlined(GraphBuilderContext b, ResolvedJavaMethod method, Invoke invoke) {
        IntrinsicContext intrinsic;
        if (b.parsingIntrinsic() && !(intrinsic = b.getIntrinsic()).isCallToOriginal(method)) {
            Class<? extends GraphBuilderPlugin> pluginClass = this.getIntrinsifyingPlugin(method);
            if (pluginClass != null) {
                String methodDesc = method.format("%H.%n(%p)");
                throw new GraalError("Call to %s should have been intrinsified by a %s. This is typically caused by Eclipse failing to run an annotation processor. This can usually be fixed by forcing Eclipse to rebuild the source file in which %s is declared", methodDesc, pluginClass.getSimpleName(), methodDesc);
            }
            throw new GraalError("All non-recursive calls in the intrinsic %s must be inlined or intrinsified: found call to %s", intrinsic.getIntrinsicMethod().format("%H.%n(%p)"), method.format("%h.%n(%p)"));
        }
    }

    public ReplacementsImpl(DebugHandlersFactory debugHandlersFactory, Providers providers, SnippetReflectionProvider snippetReflection, BytecodeProvider bytecodeProvider, TargetDescription target) {
        this.providers = providers.copyWith(this);
        this.snippetReflection = snippetReflection;
        this.target = target;
        this.graphs = new ConcurrentHashMap<ResolvedJavaMethod, StructuredGraph>();
        this.snippetTemplateCache = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        this.defaultBytecodeProvider = bytecodeProvider;
        this.debugHandlersFactory = debugHandlersFactory;
    }

    @Override
    public DebugContext openSnippetDebugContext(String idPrefix, ResolvedJavaMethod method, DebugContext outer, OptionValues options) {
        if (DebugOptions.DebugStubsAndSnippets.getValue(options).booleanValue()) {
            return this.openDebugContext(idPrefix, method, options, outer, false);
        }
        if (DebugOptions.DumpOnError.getValue(options).booleanValue()) {
            return this.openDebugContext(idPrefix, method, options, outer, true);
        }
        return DebugContext.disabled(options);
    }

    public DebugContext openSnippetDebugContext(String idPrefix, ResolvedJavaMethod method, OptionValues options) {
        return this.openSnippetDebugContext(idPrefix, method, DebugContext.forCurrentThread(), options);
    }

    public DebugContext openDebugContext(String idPrefix, ResolvedJavaMethod method, OptionValues options) {
        return this.openDebugContext(idPrefix, method, options, DebugContext.forCurrentThread(), false);
    }

    private DebugContext openDebugContext(String idPrefix, ResolvedJavaMethod method, OptionValues options, DebugContext outer, boolean disabled) {
        DebugContext.Description description = new DebugContext.Description(method, idPrefix + nextDebugContextId.incrementAndGet());
        return new DebugContext.Builder(options, this.debugHandlersFactory).globalMetrics(outer.getGlobalMetrics()).description(description).disabled(disabled).build();
    }

    @Override
    public StructuredGraph getSnippet(ResolvedJavaMethod method, ResolvedJavaMethod recursiveEntry, Object[] args, BitSet nonNullParameters, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, OptionValues options) {
        StructuredGraph graph;
        assert (method.getAnnotation(Snippet.class) != null) : "Snippet must be annotated with @" + Snippet.class.getSimpleName();
        assert (method.hasBytecodes()) : "Snippet must not be abstract or native";
        StructuredGraph structuredGraph = graph = GraalOptions.UseSnippetGraphCache.getValue(options) != false ? (StructuredGraph)this.graphs.get(method) : null;
        if (graph == null || trackNodeSourcePosition && !graph.trackNodeSourcePosition()) {
            try (DebugContext debug = this.openSnippetDebugContext("Snippet_", method, options);
                 DebugCloseable a = SnippetPreparationTime.start(debug);){
                StructuredGraph newGraph = this.makeGraph(debug, this.defaultBytecodeProvider, method, args, nonNullParameters, recursiveEntry, trackNodeSourcePosition, replaceePosition, IntrinsicContext.CompilationContext.INLINE_AFTER_PARSING);
                DebugContext.counter("SnippetNodeCount[%#s]", method).add(newGraph.getDebug(), newGraph.getNodeCount());
                if (!GraalOptions.UseSnippetGraphCache.getValue(options).booleanValue() || args != null) {
                    StructuredGraph structuredGraph2 = newGraph;
                    return structuredGraph2;
                }
                newGraph.freeze();
                if (graph != null) {
                    this.graphs.replace(method, graph, newGraph);
                } else {
                    this.graphs.putIfAbsent(method, newGraph);
                }
                graph = (StructuredGraph)this.graphs.get(method);
            }
        }
        assert (!trackNodeSourcePosition || graph.trackNodeSourcePosition());
        return graph;
    }

    @Override
    public SnippetParameterInfo getSnippetParameterInfo(ResolvedJavaMethod method) {
        return new SnippetParameterInfo(method);
    }

    @Override
    public boolean isSnippet(ResolvedJavaMethod method) {
        return method.getAnnotation(Snippet.class) != null;
    }

    @Override
    public void registerSnippet(ResolvedJavaMethod method, ResolvedJavaMethod original, Object receiver, boolean trackNodeSourcePosition, OptionValues options) {
    }

    @Override
    public void registerConditionalPlugin(InvocationPlugin plugin) {
    }

    @Override
    public boolean hasSubstitution(ResolvedJavaMethod method, OptionValues options) {
        InvocationPlugin plugin = this.graphBuilderPlugins.getInvocationPlugins().lookupInvocation(method, options);
        return plugin != null;
    }

    @Override
    public BytecodeProvider getDefaultReplacementBytecodeProvider() {
        return this.defaultBytecodeProvider;
    }

    @Override
    public StructuredGraph getInlineSubstitution(ResolvedJavaMethod method, int invokeBci, Invoke.InlineControl inlineControl, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, StructuredGraph.AllowAssumptions allowAssumptions, OptionValues options) {
        StructuredGraph result;
        assert (invokeBci >= 0) : method;
        if (!inlineControl.allowSubstitution()) {
            return null;
        }
        InvocationPlugin plugin = this.graphBuilderPlugins.getInvocationPlugins().lookupInvocation(method, options);
        if (plugin != null) {
            ResolvedJavaMethodBytecode code = new ResolvedJavaMethodBytecode(method);
            try (DebugContext debug = this.openSnippetDebugContext("Substitution_", method, options);){
                result = new IntrinsicGraphBuilder(options, debug, this.providers, code, invokeBci, allowAssumptions).buildGraph(plugin);
            }
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public StructuredGraph getIntrinsicGraph(ResolvedJavaMethod method, CompilationIdentifier compilationId, DebugContext debug, StructuredGraph.AllowAssumptions allowAssumptions, Cancellable cancellable) {
        InvocationPlugin plugin = this.graphBuilderPlugins.getInvocationPlugins().lookupInvocation(method, debug.getOptions());
        if (plugin != null && !plugin.inlineOnly()) {
            assert (!plugin.isDecorator()) : "lookupInvocation shouldn't return decorator plugins";
            ResolvedJavaMethodBytecode code = new ResolvedJavaMethodBytecode(method);
            OptionValues options = debug.getOptions();
            GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(this.getGraphBuilderPlugins());
            GraphBuilderConfiguration config = GraphBuilderConfiguration.getSnippetDefault(plugins);
            return new IntrinsicGraphBuilder(options, debug, this.providers, code, -1, StructuredGraph.AllowAssumptions.YES, config).buildGraph(plugin);
        }
        return null;
    }

    public StructuredGraph makeGraph(DebugContext debug, BytecodeProvider bytecodeProvider, ResolvedJavaMethod method, Object[] args, BitSet nonNullParameters, ResolvedJavaMethod original, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, IntrinsicContext.CompilationContext context) {
        return this.createGraphMaker(method, original).makeGraph(debug, bytecodeProvider, args, nonNullParameters, trackNodeSourcePosition, replaceePosition, context);
    }

    public final StructuredGraph makeGraph(DebugContext debug, BytecodeProvider bytecodeProvider, ResolvedJavaMethod method, Object[] args, BitSet nonNullParameters, ResolvedJavaMethod original, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition) {
        return this.makeGraph(debug, bytecodeProvider, method, args, nonNullParameters, original, trackNodeSourcePosition, replaceePosition, IntrinsicContext.CompilationContext.INLINE_AFTER_PARSING);
    }

    protected GraphMaker createGraphMaker(ResolvedJavaMethod substitute, ResolvedJavaMethod original) {
        return new GraphMaker(this, substitute, original);
    }

    @Override
    public void registerSnippetTemplateCache(SnippetTemplateCache templates) {
        assert (this.snippetTemplateCache.get((Object)templates.getClass().getName()) == null);
        this.snippetTemplateCache.put((Object)templates.getClass().getName(), (Object)templates);
    }

    @Override
    public <T extends SnippetTemplateCache> T getSnippetTemplateCache(Class<T> templatesClass) {
        SnippetTemplateCache ret = (SnippetTemplateCache)this.snippetTemplateCache.get((Object)templatesClass.getName());
        return (T)((SnippetTemplateCache)templatesClass.cast(ret));
    }

    @Override
    public JavaKind getWordKind() {
        return this.getProviders().getWordTypes().getWordKind();
    }

    public static class GraphMaker {
        protected final ReplacementsImpl replacements;
        protected final ResolvedJavaMethod method;
        protected final ResolvedJavaMethod substitutedMethod;

        public GraphMaker(ReplacementsImpl replacements, ResolvedJavaMethod substitute, ResolvedJavaMethod substitutedMethod) {
            this.replacements = replacements;
            this.method = substitute;
            this.substitutedMethod = substitutedMethod;
        }

        public StructuredGraph makeGraph(DebugContext debug, BytecodeProvider bytecodeProvider, Object[] args, BitSet nonNullParameters, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, IntrinsicContext.CompilationContext context) {
            DebugContext.Scope s = debug.scope((Object)"BuildSnippetGraph", this.method);
            try {
                assert (this.method.hasBytecodes()) : this.method;
                StructuredGraph graph = this.buildInitialGraph(debug, bytecodeProvider, this.method, args, nonNullParameters, trackNodeSourcePosition, replaceePosition, context);
                this.finalizeGraph(graph);
                debug.dump(2, (Object)graph, "%s: Final", this.method.getName());
                StructuredGraph structuredGraph = graph;
                if (s != null) {
                    s.close();
                }
                return structuredGraph;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    throw debug.handle(e);
                }
            }
        }

        protected void finalizeGraph(StructuredGraph graph) {
            if (!GraalOptions.SnippetCounters.getValue(graph.getOptions()).booleanValue() || graph.getNodes().filter(SnippetCounterNode.class).isEmpty()) {
                int sideEffectCount = 0;
                assert ((sideEffectCount = graph.getNodes().filter(e -> this.hasSideEffect(e)).count()) >= 0);
                new ConvertDeoptimizeToGuardPhase(CanonicalizerPhase.create()).apply(graph, this.replacements.getProviders());
                assert (sideEffectCount == graph.getNodes().filter(e -> this.hasSideEffect(e)).count()) : "deleted side effecting node";
                new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Required).apply(graph);
            }
        }

        private boolean hasSideEffect(Node node) {
            if (node instanceof StateSplit && ((StateSplit)((Object)node)).hasSideEffect()) {
                ResolvedJavaMethod targetMethod;
                CallTargetNode callTarget;
                if (node instanceof Invoke && (callTarget = ((Invoke)((Object)node)).callTarget()) instanceof MethodCallTargetNode && (targetMethod = ((MethodCallTargetNode)callTarget).targetMethod()).isConstructor()) {
                    ResolvedJavaType throwableType = this.replacements.providers.getMetaAccess().lookupJavaType(Throwable.class);
                    return !throwableType.isAssignableFrom(targetMethod.getDeclaringClass());
                }
                return true;
            }
            return false;
        }

        protected StructuredGraph buildInitialGraph(DebugContext debug, BytecodeProvider bytecodeProvider, ResolvedJavaMethod methodToParse, Object[] args, BitSet nonNullParameters, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, IntrinsicContext.CompilationContext context) {
            StructuredGraph graph = new StructuredGraph.Builder(debug.getOptions(), debug, StructuredGraph.AllowAssumptions.NO).method(methodToParse).trackNodeSourcePosition(trackNodeSourcePosition).callerContext(replaceePosition).setIsSubstitution(true).build();
            graph.disableUnsafeAccessTracking();
            try (DebugContext.Scope s = debug.scope((Object)"buildInitialGraph", graph);){
                MetaAccessProvider metaAccess = this.replacements.getProviders().getMetaAccess();
                GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(this.replacements.graphBuilderPlugins);
                GraphBuilderConfiguration config = GraphBuilderConfiguration.getSnippetDefault(plugins);
                if (args != null) {
                    plugins.prependParameterPlugin(new ConstantBindingParameterPlugin(args, metaAccess, this.replacements.snippetReflection));
                }
                if (nonNullParameters != null && !nonNullParameters.isEmpty()) {
                    plugins.appendParameterPlugin(new NonNullParameterPlugin(nonNullParameters));
                }
                EncodedIntrinsicContext initialIntrinsicContext = null;
                Snippet snippetAnnotation = null;
                if (!Services.IS_IN_NATIVE_IMAGE) {
                    snippetAnnotation = (Snippet)this.method.getAnnotation(Snippet.class);
                }
                if (snippetAnnotation == null) {
                    initialIntrinsicContext = new EncodedIntrinsicContext(this.substitutedMethod, this.method, bytecodeProvider, context, false);
                } else {
                    ResolvedJavaMethod original = this.substitutedMethod != null ? this.substitutedMethod : this.method;
                    initialIntrinsicContext = new EncodedIntrinsicContext(original, this.method, bytecodeProvider, context, snippetAnnotation.allowPartialIntrinsicArgumentMismatch());
                }
                this.createGraphBuilder(this.replacements.providers, config, OptimisticOptimizations.NONE, initialIntrinsicContext).apply(graph);
                CanonicalizerPhase.create().apply(graph, this.replacements.providers);
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
            return graph;
        }

        protected GraphBuilderPhase.Instance createGraphBuilder(Providers providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
            return new GraphBuilderPhase.Instance(providers, graphBuilderConfig, optimisticOpts, initialIntrinsicContext);
        }

        static class EncodedIntrinsicContext
        extends IntrinsicContext {
            EncodedIntrinsicContext(ResolvedJavaMethod method, ResolvedJavaMethod intrinsic, BytecodeProvider bytecodeProvider, IntrinsicContext.CompilationContext compilationContext, boolean allowPartialIntrinsicArgumentMismatch) {
                super(method, intrinsic, bytecodeProvider, compilationContext, allowPartialIntrinsicArgumentMismatch);
            }

            @Override
            public boolean isDeferredInvoke(StateSplit stateSplit) {
                if (Services.IS_IN_NATIVE_IMAGE) {
                    throw GraalError.shouldNotReachHere("unused in libgraal");
                }
                if (stateSplit instanceof Invoke) {
                    Invoke invoke = (Invoke)stateSplit;
                    ResolvedJavaMethod method = invoke.callTarget().targetMethod();
                    if (method == null) {
                        return false;
                    }
                    if (method.getAnnotation(Fold.class) != null) {
                        return true;
                    }
                    Node.NodeIntrinsic annotation = (Node.NodeIntrinsic)method.getAnnotation(Node.NodeIntrinsic.class);
                    if (annotation != null && !annotation.hasSideEffect()) {
                        return true;
                    }
                }
                return false;
            }
        }
    }
}

